/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterConfig;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.ControllerMetaData;
import org.javalite.activeweb.ControllerPackageLocator;
import org.javalite.activeweb.controller_filters.ControllerFilter;

class ControllerRegistry {
    private Map<String, ControllerMetaData> metaDataMap = new HashMap<String, ControllerMetaData>();
    private List<FilterList> globalFilterLists = new ArrayList<FilterList>();
    private Injector injector;
    private List<String> controllerPackages;
    private final Object token = new Object();
    private boolean filtersInjected;

    protected ControllerRegistry(FilterConfig config) {
        this.controllerPackages = ControllerPackageLocator.locateControllerPackages(config);
    }

    protected ControllerMetaData getMetaData(Class<? extends AppController> controllerClass) {
        if (this.metaDataMap.get(controllerClass.getName()) == null) {
            this.metaDataMap.put(controllerClass.getName(), new ControllerMetaData());
        }
        return this.metaDataMap.get(controllerClass.getName());
    }

    protected void addGlobalFilters(ControllerFilter ... filters) {
        this.globalFilterLists.add(new FilterList((List)Arrays.asList(filters)));
    }

    protected void addGlobalFilters(List<ControllerFilter> filters, List<Class<? extends AppController>> excludeControllerClasses) {
        this.globalFilterLists.add(new FilterList(filters, excludeControllerClasses));
    }

    protected List<FilterList> getGlobalFilterLists() {
        return Collections.unmodifiableList(this.globalFilterLists);
    }

    protected void setInjector(Injector injector) {
        this.injector = injector;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void injectFilters() {
        if (!this.filtersInjected) {
            Object object = this.token;
            synchronized (object) {
                if (this.injector != null) {
                    for (FilterList filterList : this.globalFilterLists) {
                        List<ControllerFilter> filters = filterList.getFilters();
                        for (ControllerFilter controllerFilter : filters) {
                            this.injector.injectMembers((Object)controllerFilter);
                        }
                    }
                    for (String key : this.metaDataMap.keySet()) {
                        this.metaDataMap.get(key).injectFilters(this.injector);
                    }
                }
                this.filtersInjected = true;
            }
        }
    }

    protected List<String> getControllerPackages() {
        return this.controllerPackages;
    }

    static class FilterList {
        private final List<ControllerFilter> filters;
        private final List<Class<? extends AppController>> excludedControllers;

        private FilterList(List<ControllerFilter> filters, List<Class<? extends AppController>> excludedControllers) {
            this.filters = filters;
            this.excludedControllers = excludedControllers;
        }

        private FilterList(List<ControllerFilter> filters) {
            this(filters, Collections.emptyList());
        }

        public List<ControllerFilter> getFilters() {
            return Collections.unmodifiableList(this.filters);
        }

        public boolean excludesController(AppController controller) {
            for (Class<? extends AppController> clazz : this.excludedControllers) {
                if (!clazz.getName().equals(controller.getClass().getName())) continue;
                return true;
            }
            return false;
        }
    }
}

