/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpSession;
import org.javalite.activeweb.ActionNotFoundException;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerException;
import org.javalite.activeweb.ControllerRegistry;
import org.javalite.activeweb.ControllerResponse;
import org.javalite.activeweb.DirectResponse;
import org.javalite.activeweb.FilterException;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.ParamCopy;
import org.javalite.activeweb.RenderTemplateResponse;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.SessionFacade;
import org.javalite.activeweb.WebException;
import org.javalite.activeweb.controller_filters.ControllerFilter;
import org.javalite.activeweb.freemarker.AbstractFreeMarkerConfig;
import org.javalite.activeweb.freemarker.FreeMarkerTemplateManager;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ControllerRunner {
    private boolean injectTags = Configuration.getTemplateManager() instanceof FreeMarkerTemplateManager;
    private static Logger LOGGER = LoggerFactory.getLogger((String)ControllerRunner.class.getSimpleName());
    private boolean tagsInjected;

    ControllerRunner() {
    }

    protected void run(Route route, boolean integrateViews) throws Exception {
        ControllerRegistry controllerRegistry = Context.getControllerRegistry();
        List<ControllerRegistry.FilterList> globalFilterLists = controllerRegistry.getGlobalFilterLists();
        List<ControllerFilter> controllerFilters = controllerRegistry.getMetaData(route.getController().getClass()).getFilters(route.getActionName());
        Context.getControllerRegistry().injectFilters();
        try {
            this.filterBefore(route, globalFilterLists, controllerFilters);
            if (Context.getControllerResponse() == null) {
                String actionMethod = Inflector.camelize((String)route.getActionName().replace('-', '_'), (boolean)false);
                if (this.checkActionMethod(route.getController(), actionMethod)) {
                    this.injectController(route.getController());
                    if (Configuration.logRequestParams()) {
                        LOGGER.info("Executing controller: " + route.getController().getClass().getName() + "." + actionMethod + ", session: " + new SessionFacade().id());
                    }
                    this.executeAction(route.getController(), actionMethod);
                }
            }
            if (this.injectTags) {
                this.injectFreemarkerTags();
            }
            this.renderResponse(route, integrateViews);
            this.processFlash();
            this.filterAfter(route, globalFilterLists, controllerFilters);
        }
        catch (ActionNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            Context.setControllerResponse(null);
            if (this.exceptionHandled(e, route, globalFilterLists, controllerFilters)) {
                LOGGER.debug("A filter has called render(..) method, proceeding to render it...");
                this.renderResponse(route, integrateViews);
            }
            throw e;
        }
    }

    private void injectFreemarkerTags() {
        if (!this.tagsInjected) {
            AbstractFreeMarkerConfig freeMarkerConfig = Configuration.getFreeMarkerConfig();
            Injector injector = Context.getControllerRegistry().getInjector();
            this.tagsInjected = true;
            if (injector == null || freeMarkerConfig == null) {
                return;
            }
            freeMarkerConfig.inject(injector);
        }
    }

    private void injectController(AppController controller) {
        Injector injector = Context.getControllerRegistry().getInjector();
        if (injector != null) {
            injector.injectMembers((Object)controller);
        }
    }

    private void renderResponse(Route route, boolean integrateViews) throws InstantiationException, IllegalAccessException {
        if (Context.getEncoding() != null) {
            Context.getHttpResponse().setCharacterEncoding(Context.getEncoding());
        } else if (route.getController().getEncoding() != null) {
            Context.getHttpResponse().setCharacterEncoding(route.getController().getEncoding());
        }
        ControllerResponse controllerResponse = Context.getControllerResponse();
        String controllerLayout = route.getController().getLayout();
        if (controllerResponse == null) {
            this.createDefaultResponse(route, controllerLayout);
        } else if (controllerResponse instanceof RenderTemplateResponse) {
            this.configureExplicitResponse(route, controllerLayout, (RenderTemplateResponse)controllerResponse);
        }
        controllerResponse = Context.getControllerResponse();
        if (integrateViews && controllerResponse instanceof RenderTemplateResponse) {
            ParamCopy.copyInto(controllerResponse.values());
            controllerResponse.process();
        } else if (!(controllerResponse instanceof RenderTemplateResponse)) {
            if (controllerResponse.getContentType() == null) {
                controllerResponse.setContentType(route.getController().getContentType());
            }
            controllerResponse.process();
        }
    }

    private void configureExplicitResponse(Route route, String controllerLayout, RenderTemplateResponse resp) throws InstantiationException, IllegalAccessException {
        if (!Configuration.getDefaultLayout().equals(controllerLayout) && resp.hasDefaultLayout()) {
            resp.setLayout(controllerLayout);
        }
        if (resp.getContentType() == null) {
            resp.setContentType(route.getController().getContentType());
        }
        resp.setTemplateManager(Configuration.getTemplateManager());
    }

    private void createDefaultResponse(Route route, String controllerLayout) throws InstantiationException, IllegalAccessException {
        String controllerPath = Router.getControllerPath(route.getController().getClass());
        String template = controllerPath + "/" + route.getActionName();
        RenderTemplateResponse resp = new RenderTemplateResponse(route.getController().values(), template, Context.getFormat());
        if (!Configuration.getDefaultLayout().equals(controllerLayout)) {
            resp.setLayout(controllerLayout);
        }
        if (resp.getContentType() == null) {
            resp.setContentType(route.getController().getContentType());
        }
        Context.setControllerResponse(resp);
        resp.setTemplateManager(Configuration.getTemplateManager());
    }

    private void processFlash() {
        Object flashObj;
        HttpSession session = Context.getHttpRequest().getSession(false);
        if (session != null && (flashObj = session.getAttribute("flasher")) != null && flashObj instanceof Map) {
            Map flasher = (Map)flashObj;
            if (flasher.get("count") == null) {
                flasher.put("count", 0);
            } else if (flasher.get("count").equals(0)) {
                session.removeAttribute("flasher");
            }
        }
    }

    private boolean checkActionMethod(AppController controller, String actionMethod) {
        HttpMethod method = HttpMethod.getMethod(Context.getHttpRequest());
        if (!controller.actionSupportsHttpMethod(actionMethod, method)) {
            DirectResponse res = new DirectResponse("");
            res.setStatus(405);
            LOGGER.warn("Requested action does not support HTTP method: " + method.name() + ", returning status code 405.");
            Context.setControllerResponse(res);
            Context.getHttpResponse().setHeader("Allow", Util.join(controller.allowedActions(actionMethod), (String)", "));
            return false;
        }
        return true;
    }

    private boolean exceptionHandled(Exception e, Route route, List<ControllerRegistry.FilterList> globalFilterLists, List<ControllerFilter> ... filterGroups) throws Exception {
        for (ControllerRegistry.FilterList filterList : globalFilterLists) {
            if (filterList.excludesController(route.getController())) continue;
            List<ControllerFilter> filters = filterList.getFilters();
            for (ControllerFilter controllerFilter : filters) {
                controllerFilter.onException(e);
            }
        }
        for (List<ControllerFilter> filterGroup : filterGroups) {
            for (ControllerFilter controllerFilter : filterGroup) {
                controllerFilter.onException(e);
            }
        }
        return Context.getControllerResponse() != null;
    }

    private void filterBefore(Route route, List<ControllerRegistry.FilterList> globalFilterLists, List<ControllerFilter> ... filterGroups) {
        try {
            for (ControllerRegistry.FilterList filterList : globalFilterLists) {
                if (filterList.excludesController(route.getController())) continue;
                List<ControllerFilter> filters = filterList.getFilters();
                for (ControllerFilter controllerFilter : filters) {
                    controllerFilter.before();
                }
            }
            for (List<ControllerFilter> filterGroup : filterGroups) {
                for (ControllerFilter controllerFilter : filterGroup) {
                    if (Configuration.logRequestParams()) {
                        LOGGER.debug("Executing filter: " + controllerFilter.getClass().getName() + "#before");
                    }
                    controllerFilter.before();
                    if (Context.getControllerResponse() == null) continue;
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FilterException(e);
        }
    }

    private void filterAfter(Route route, List<ControllerRegistry.FilterList> globalFilterLists, List<ControllerFilter> ... filterGroups) {
        try {
            for (ControllerRegistry.FilterList filterList : globalFilterLists) {
                if (filterList.excludesController(route.getController())) continue;
                List<ControllerFilter> filters = filterList.getFilters();
                for (ControllerFilter controllerFilter : filters) {
                    controllerFilter.after();
                }
            }
            for (List<ControllerFilter> filterGroup : filterGroups) {
                for (int i = filterGroup.size() - 1; i >= 0; --i) {
                    if (Configuration.logRequestParams()) {
                        LOGGER.debug("Executing filter: " + filterGroup.get(i).getClass().getName() + "#after");
                    }
                    filterGroup.get(i).after();
                }
            }
        }
        catch (Exception e) {
            throw new FilterException(e);
        }
    }

    private void executeAction(Object controller, String actionName) {
        try {
            Method m = controller.getClass().getMethod(actionName, new Class[0]);
            Class<?> c = m.getDeclaringClass();
            if (!AppController.class.isAssignableFrom(m.getDeclaringClass())) {
                throw new ActionNotFoundException("Cannot execute action '" + actionName + "' on controller: " + controller);
            }
            m.invoke(controller, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof WebException) {
                throw (WebException)e.getCause();
            }
            if (e.getCause() != null && e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            if (e.getCause() != null) {
                throw new ControllerException(e.getCause());
            }
        }
        catch (WebException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }
}

