/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cookie {
    private static Logger LOGGER = LoggerFactory.getLogger((String)Cookie.class.getSimpleName());
    private String name;
    private String value;
    private int maxAge = -1;
    private String domain;
    private String path = "/";
    private boolean secure;
    private boolean httpOnly;
    private int version;

    public Cookie(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Cookie(String name, String value, boolean httpOnly) {
        this.name = name;
        this.value = value;
        this.httpOnly = httpOnly;
    }

    public void setMaxAge(int maxAge) {
        this.maxAge = maxAge;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setHttpOnly() {
        this.httpOnly = true;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String toString() {
        return "Cookie{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", maxAge=" + this.maxAge + ", domain='" + this.domain + '\'' + ", path='" + this.path + '\'' + ", secure=" + this.secure + ", version=" + this.version + '}';
    }

    static Cookie fromServletCookie(javax.servlet.http.Cookie servletCookie) {
        Cookie cookie = new Cookie(servletCookie.getName(), servletCookie.getValue());
        cookie.setMaxAge(servletCookie.getMaxAge());
        cookie.setDomain(servletCookie.getDomain());
        cookie.setPath(servletCookie.getPath());
        cookie.setSecure(servletCookie.getSecure());
        cookie.setVersion(servletCookie.getVersion());
        cookie.setHttpOnly(Cookie.isHttpOnlyReflect(servletCookie));
        return cookie;
    }

    static javax.servlet.http.Cookie toServletCookie(Cookie cookie) {
        javax.servlet.http.Cookie servletCookie = new javax.servlet.http.Cookie(cookie.getName(), cookie.getValue());
        servletCookie.setMaxAge(cookie.getMaxAge());
        if (cookie.getDomain() != null) {
            servletCookie.setDomain(cookie.getDomain());
        }
        servletCookie.setPath(cookie.getPath());
        servletCookie.setSecure(cookie.isSecure());
        servletCookie.setVersion(cookie.getVersion());
        Cookie.setHttpOnlyReflect(cookie, servletCookie);
        return servletCookie;
    }

    private static void setHttpOnlyReflect(Cookie awCookie, javax.servlet.http.Cookie servletCookie) {
        try {
            servletCookie.getClass().getMethod("setHttpOnly", Boolean.TYPE).invoke((Object)servletCookie, awCookie.isHttpOnly());
        }
        catch (Exception e) {
            LOGGER.warn("You are trying to set HttpOnly on a cookie, but it appears you are running on Servlet version before 3.0.");
        }
    }

    private static boolean isHttpOnlyReflect(javax.servlet.http.Cookie servletCookie) {
        try {
            return (Boolean)servletCookie.getClass().getMethod("isHttpOnly", new Class[0]).invoke((Object)servletCookie, new Object[0]);
        }
        catch (Exception e) {
            LOGGER.warn("You are trying to get HttpOnly from a cookie, but it appears you are running on Servlet version before 3.0. Returning false.. which can be false!");
            return false;
        }
    }
}

