/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Collection;
import org.javalite.activeweb.ClassLoadException;
import org.javalite.activeweb.CompilationException;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.DynamicClassLoader;
import org.javalite.common.Collections;
import org.javalite.common.Util;

public abstract class DynamicClassFactory {
    public static <T> T createInstance(String className, Class<T> expectedType) throws ClassLoadException {
        try {
            Object o = DynamicClassFactory.getCompiledClass(className).newInstance();
            T instance = expectedType.cast(o);
            return instance;
        }
        catch (ClassLoadException | CompilationException e) {
            throw e;
        }
        catch (ClassCastException e) {
            throw new ClassLoadException("Class: " + className + " is not the expected type, are you sure it extends " + expectedType.getName() + "?");
        }
        catch (Exception e) {
            throw new ClassLoadException(e);
        }
    }

    public static Class getCompiledClass(String className) throws ClassLoadException {
        try {
            Class<?> theClass;
            if (Configuration.activeReload()) {
                String compilationResult = DynamicClassFactory.compileClass(className);
                if (compilationResult.contains("cannot read")) {
                    throw new ClassLoadException(compilationResult);
                }
                if (compilationResult.contains("error")) {
                    throw new CompilationException(compilationResult);
                }
                DynamicClassLoader dynamicClassLoader = new DynamicClassLoader(ControllerFactory.class.getClassLoader(), Configuration.getTargetDir());
                theClass = dynamicClassLoader.loadClass(className);
            } else {
                theClass = Class.forName(className);
            }
            return theClass;
        }
        catch (CompilationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassLoadException(e);
        }
    }

    protected static synchronized String compileClass(String className) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String controllerFileName = className.replace(".", System.getProperty("file.separator")) + ".java";
        URLClassLoader loader = (URLClassLoader)Thread.currentThread().getContextClassLoader();
        URL[] urls = loader.getURLs();
        String classpath = DynamicClassFactory.getClasspath(urls);
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        String targetClasses = Util.join((Collection)Collections.list((Object[])new String[]{"target", "classes"}), (String)System.getProperty("file.separator"));
        String srcMainJava = Util.join((Collection)Collections.list((Object[])new String[]{"src", "main", "java"}), (String)System.getProperty("file.separator"));
        String[] args = new String[]{"-g:lines,source,vars", "-d", targetClasses, "-cp", classpath, srcMainJava + System.getProperty("file.separator") + controllerFileName};
        Class<?> cl = Class.forName("com.sun.tools.javac.Main");
        Method compile = cl.getMethod("compile", String[].class, PrintWriter.class);
        compile.invoke(null, args, out);
        out.flush();
        return writer.toString();
    }

    private static String getClasspath(URL[] urls) {
        String classpath = "";
        for (URL url : urls) {
            String path = url.getPath();
            if (System.getProperty("os.name").contains("Windows")) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                try {
                    path = URLDecoder.decode(path, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                path = path.replace("/", "\\");
            }
            classpath = classpath + path + System.getProperty("path.separator");
        }
        return classpath;
    }
}

