/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.FileInputStream;
import java.io.InputStream;
import org.javalite.activeweb.Configuration;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicClassLoader
extends ClassLoader {
    private static Logger LOGGER = LoggerFactory.getLogger((String)DynamicClassLoader.class.getSimpleName());
    private String baseDir;

    DynamicClassLoader(ClassLoader parent, String baseDir) {
        super(parent);
        this.baseDir = baseDir;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        try {
            if (name.startsWith("org.javalite.activeweb")) {
                return this.loadByParent(name);
            }
            if (name.endsWith("Controller") || name.contains("Controller$") || name.equals(Configuration.getRouteConfigClassName())) {
                String pathToClassFile = name.replace('.', '/') + ".class";
                byte[] classBytes = Util.bytes((InputStream)this.getResourceAsStream(pathToClassFile));
                Class<?> daClass = this.defineClass(name, classBytes, 0, classBytes.length);
                LOGGER.debug("Loaded class: " + name);
                return daClass;
            }
            return this.loadByParent(name);
        }
        catch (Exception e) {
            LOGGER.debug("Failed to dynamically load class: " + name + ". Loading by parent class loader.");
            return this.loadByParent(name);
        }
    }

    private Class<?> loadByParent(String name) throws ClassNotFoundException {
        return Thread.currentThread().getContextClassLoader().loadClass(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        try {
            String pathToFile = this.baseDir + System.getProperty("file.separator") + name;
            return new FileInputStream(pathToFile);
        }
        catch (Exception e) {
            return super.getResourceAsStream(name);
        }
    }
}

