/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerException;
import org.javalite.activeweb.ControllerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FileResponse
extends ControllerResponse {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResponse.class);
    private File file;
    private boolean delete;

    FileResponse(File file) {
        this.file = file;
    }

    FileResponse(File file, boolean delete) {
        this(file);
        this.delete = delete;
    }

    @Override
    void doProcess() {
        try {
            this.stream(new FileInputStream(this.file), (OutputStream)Context.getHttpResponse().getOutputStream());
            if (this.delete && !this.file.delete()) {
                LOGGER.warn("failed to delete file: " + this.file + " after processing");
            }
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }
}

