/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.fileupload.FileItemStream;
import org.javalite.activeweb.ApacheFileItemFacade;
import org.javalite.activeweb.ControllerException;
import org.javalite.common.Util;

public class FormItem {
    private FileItemStream fileItemStream;

    FormItem(FileItemStream fileItemStream) {
        this.fileItemStream = fileItemStream;
    }

    public FormItem(String name, String fieldName, boolean isFile, String contentType, byte[] content) {
        this.fileItemStream = new ApacheFileItemFacade(name, fieldName, contentType, isFile, content);
    }

    FormItem(ApacheFileItemFacade apacheFileItemFacade) {
        this.fileItemStream = apacheFileItemFacade;
    }

    public String getName() {
        return this.fileItemStream.getName();
    }

    public String getFileName() {
        return this.fileItemStream.getName();
    }

    public String getFieldName() {
        return this.fileItemStream.getFieldName();
    }

    public boolean isFile() {
        return !this.fileItemStream.isFormField();
    }

    public String getContentType() {
        return this.fileItemStream.getContentType();
    }

    public boolean isFormField() {
        return this.fileItemStream.isFormField();
    }

    public InputStream getInputStream() {
        try {
            return this.fileItemStream.openStream();
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public String getString() {
        return this.getStreamAsString();
    }

    public String getStreamAsString() {
        try {
            return Util.read((InputStream)this.fileItemStream.openStream());
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public byte[] getBytes() {
        try {
            return Util.bytes((InputStream)this.fileItemStream.openStream());
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public void saveTo(String path) throws IOException {
        Util.saveTo((String)path, (InputStream)this.getInputStream());
    }
}

