/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;
import org.javalite.activeweb.annotations.DELETE;
import org.javalite.activeweb.annotations.GET;
import org.javalite.activeweb.annotations.HEAD;
import org.javalite.activeweb.annotations.OPTIONS;
import org.javalite.activeweb.annotations.PATCH;
import org.javalite.activeweb.annotations.POST;
import org.javalite.activeweb.annotations.PUT;

public enum HttpMethod {
    GET,
    POST,
    PUT,
    DELETE,
    PATCH,
    HEAD,
    OPTIONS;


    public static HttpMethod method(Annotation annotation) {
        if (annotation instanceof GET) {
            return GET;
        }
        if (annotation instanceof POST) {
            return POST;
        }
        if (annotation instanceof PUT) {
            return PUT;
        }
        if (annotation instanceof DELETE) {
            return DELETE;
        }
        if (annotation instanceof PATCH) {
            return PATCH;
        }
        if (annotation instanceof HEAD) {
            return HEAD;
        }
        if (annotation instanceof OPTIONS) {
            return OPTIONS;
        }
        throw new IllegalArgumentException("Allowed annotations can be found in 'org.javalite.activeweb.annotations' package.");
    }

    static HttpMethod getMethod(HttpServletRequest request) {
        String methodParam = request.getParameter("_method");
        String requestMethod = request.getMethod();
        requestMethod = requestMethod.equalsIgnoreCase("POST") && methodParam != null && methodParam.equalsIgnoreCase("DELETE") ? "DELETE" : requestMethod;
        requestMethod = requestMethod.equalsIgnoreCase("POST") && methodParam != null && methodParam.equalsIgnoreCase("PUT") ? "PUT" : requestMethod;
        requestMethod = requestMethod.equalsIgnoreCase("POST") && request.getHeader("X-HTTP-Method-Override") != null && request.getHeader("X-HTTP-Method-Override").equalsIgnoreCase("PATCH") ? "PATCH" : requestMethod;
        return HttpMethod.valueOf(requestMethod.toUpperCase());
    }
}

