/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.javalite.activeweb.AWMockMultipartHttpServletRequest;
import org.javalite.activeweb.ApacheFileItemFacade;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerException;
import org.javalite.activeweb.ControllerResponse;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.DirectResponse;
import org.javalite.activeweb.FileItem;
import org.javalite.activeweb.FileResponse;
import org.javalite.activeweb.FormItem;
import org.javalite.activeweb.FormItemIterator;
import org.javalite.activeweb.KeyWords;
import org.javalite.activeweb.NopResponse;
import org.javalite.activeweb.RedirectResponse;
import org.javalite.activeweb.RenderTemplateResponse;
import org.javalite.activeweb.RequestUtils;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.SessionFacade;
import org.javalite.activeweb.StreamResponse;
import org.javalite.activeweb.WebException;
import org.javalite.common.Collections;
import org.javalite.common.Convert;
import org.javalite.common.JsonHelper;
import org.javalite.common.Util;
import org.jsoup.Jsoup;
import org.jsoup.safety.Whitelist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSupport {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private List<FormItem> formItems;
    private static Pattern hashPattern = Pattern.compile("\\[.*\\]");

    protected void logInfo(String info) {
        this.logger.info(info);
    }

    protected void logDebug(String info) {
        this.logger.debug(info);
    }

    protected void logWarning(String info) {
        this.logger.warn(info);
    }

    protected void logWarning(String info, Throwable e) {
        this.logger.warn(info, e);
    }

    protected void logError(String info) {
        this.logger.error(info);
    }

    protected void logError(Throwable e) {
        this.logger.error("", e);
    }

    protected void logError(String info, Throwable e) {
        this.logger.error(info, e);
    }

    protected void assign(String name, Object value) {
        KeyWords.check(name);
        Context.getValues().put(name, value);
    }

    protected void view(String name, Object value) {
        this.assign(name, value);
    }

    protected void view(Map values) {
        for (Object key : values.keySet()) {
            this.assign(key.toString(), values.get(key));
        }
    }

    protected void view(Object ... values) {
        this.view(Collections.map((Object[])values));
    }

    protected void flash(Map values) {
        this.checkFlasher();
        for (Object key : values.keySet()) {
            this.flash(key.toString(), values.get(key));
        }
    }

    protected void flash(Object ... values) {
        this.flash(Collections.map((Object[])values));
    }

    protected void flash(String name) {
        this.flash(name, null);
    }

    protected void flash(String name, Object value) {
        this.checkFlasher();
        ((Map)this.session().get("flasher")).put(name, value);
    }

    private void checkFlasher() {
        if (this.session().get("flasher") == null) {
            this.session().put("flasher", new HashMap());
        }
    }

    protected RenderBuilder render(String template, Map values) {
        RenderTemplateResponse resp = new RenderTemplateResponse(values, template, Context.getFormat());
        Context.setControllerResponse(resp);
        return new RenderBuilder(resp);
    }

    protected HttpBuilder redirect(String path) {
        RedirectResponse resp = new RedirectResponse(path);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected HttpBuilder redirect(URL url) {
        RedirectResponse resp = new RedirectResponse(url);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected HttpBuilder redirectToReferrer(String defaultReference) {
        String referrer = Context.getHttpRequest().getHeader("Referer");
        referrer = referrer == null ? defaultReference : referrer;
        RedirectResponse resp = new RedirectResponse(referrer);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected HttpBuilder redirectToReferrer() {
        String referrer = Context.getHttpRequest().getHeader("Referer");
        referrer = referrer == null ? Context.getHttpRequest().getContextPath() : referrer;
        RedirectResponse resp = new RedirectResponse(referrer);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected <T extends AppController> HttpBuilder redirect(Class<T> controllerClass, String action, Object id) {
        return this.redirect(controllerClass, Collections.map((Object[])new Object[]{"action", action, "id", id}));
    }

    protected <T extends AppController> HttpBuilder redirect(Class<T> controllerClass, Object id) {
        return this.redirect(controllerClass, Collections.map((Object[])new Object[]{"id", id}));
    }

    protected <T extends AppController> HttpBuilder redirect(Class<T> controllerClass, String action) {
        return this.redirect(controllerClass, Collections.map((Object[])new Object[]{"action", action}));
    }

    protected HttpBuilder redirect() {
        return this.redirect(this.getRoute().getController().getClass());
    }

    protected <T extends AppController> HttpBuilder redirect(Class<T> controllerClass) {
        return this.redirect(controllerClass, new HashMap());
    }

    protected <T extends AppController> HttpBuilder redirect(Class<T> controllerClass, Map params) {
        String controllerPath = Router.getControllerPath(controllerClass);
        String contextPath = Context.getHttpRequest().getContextPath();
        String action = params.get("action") != null ? params.get("action").toString() : null;
        String id = params.get("id") != null ? params.get("id").toString() : null;
        boolean restful = AppController.restful(controllerClass);
        params.remove("action");
        params.remove("id");
        String uri = contextPath + Router.generate(controllerPath, action, id, restful, params);
        RedirectResponse resp = new RedirectResponse(uri);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected HttpBuilder respond(String text) {
        DirectResponse resp = new DirectResponse(text);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected HttpBuilder sendFile(File file, boolean delete) throws FileNotFoundException {
        try {
            FileResponse resp = new FileResponse(file, delete);
            Context.setControllerResponse(resp);
            HttpBuilder builder = new HttpBuilder(resp);
            builder.header("Content-Disposition", "attachment; filename=" + file.getName());
            return builder;
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    protected HttpBuilder sendFile(File file) throws FileNotFoundException {
        return this.sendFile(file, false);
    }

    protected FileItem getFile(String fieldName, List<FormItem> formItems) {
        for (FormItem formItem : formItems) {
            if (!(formItem instanceof FileItem) || !formItem.getFieldName().equals(fieldName)) continue;
            return (FileItem)formItem;
        }
        return null;
    }

    protected String param(String name) {
        return RequestUtils.param(name);
    }

    protected String param(String name, List<FormItem> formItems) {
        return RequestUtils.param(name, formItems);
    }

    protected boolean exists(String name) {
        return RequestUtils.exists(name);
    }

    protected boolean requestHas(String name) {
        return RequestUtils.requestHas(name);
    }

    protected String host() {
        return RequestUtils.host();
    }

    protected String ipAddress() {
        return RequestUtils.ipAddress();
    }

    protected String getRequestProtocol() {
        return RequestUtils.getRequestProtocol();
    }

    protected int getRequestPort() {
        return RequestUtils.getRequestPort();
    }

    protected HttpServletRequest getHttpServletRequest() {
        return Context.getHttpRequest();
    }

    protected int port() {
        return RequestUtils.port();
    }

    protected String protocol() {
        return RequestUtils.protocol();
    }

    protected String getRequestHost() {
        return RequestUtils.getRequestHost();
    }

    protected String ipForwardedFor() {
        return RequestUtils.ipForwardedFor();
    }

    protected String getId() {
        return RequestUtils.getId();
    }

    protected Iterator<FormItem> uploadedFiles() {
        return this.uploadedFiles(null, -1L);
    }

    protected Iterator<FormItem> uploadedFiles(String encoding) {
        return this.uploadedFiles(encoding, -1L);
    }

    protected Iterator<FormItem> uploadedFiles(String encoding, long maxFileSize) {
        FormItemIterator iterator;
        HttpServletRequest req = Context.getHttpRequest();
        if (req instanceof AWMockMultipartHttpServletRequest) {
            iterator = ((AWMockMultipartHttpServletRequest)req).getFormItemIterator();
        } else {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                throw new ControllerException("this is not a multipart request, be sure to add this attribute to the form: ... enctype=\"multipart/form-data\" ...");
            }
            ServletFileUpload upload = new ServletFileUpload();
            if (encoding != null) {
                upload.setHeaderEncoding(encoding);
            }
            upload.setFileSizeMax(maxFileSize);
            try {
                FileItemIterator it = upload.getItemIterator(Context.getHttpRequest());
                iterator = new FormItemIterator(it);
            }
            catch (Exception e) {
                throw new ControllerException(e);
            }
        }
        return iterator;
    }

    protected List<FormItem> multipartFormItems() {
        return this.multipartFormItems(null);
    }

    protected List<FormItem> multipartFormItems(String encoding) {
        if (this.formItems != null) {
            return this.formItems;
        }
        HttpServletRequest req = Context.getHttpRequest();
        if (!(req instanceof AWMockMultipartHttpServletRequest)) {
            if (!ServletFileUpload.isMultipartContent((HttpServletRequest)req)) {
                throw new ControllerException("this is not a multipart request, be sure to add this attribute to the form: ... enctype=\"multipart/form-data\" ...");
            }
            DiskFileItemFactory factory = new DiskFileItemFactory();
            factory.setSizeThreshold(Configuration.getMaxUploadSize());
            factory.setRepository(Configuration.getTmpDir());
            ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
            if (encoding != null) {
                upload.setHeaderEncoding(encoding);
            }
            upload.setFileSizeMax((long)Configuration.getMaxUploadSize());
            try {
                List apacheFileItems = upload.parseRequest(Context.getHttpRequest());
                this.formItems = new ArrayList<FormItem>();
                for (org.apache.commons.fileupload.FileItem apacheItem : apacheFileItems) {
                    ApacheFileItemFacade f = new ApacheFileItemFacade(apacheItem);
                    if (f.isFormField()) {
                        this.formItems.add(new FormItem(f));
                        continue;
                    }
                    this.formItems.add(new FileItem(f));
                }
                return this.formItems;
            }
            catch (Exception e) {
                throw new ControllerException(e);
            }
        }
        this.formItems = ((AWMockMultipartHttpServletRequest)req).getFormItems();
        return this.formItems;
    }

    protected List<String> params(String name) {
        return RequestUtils.params(name);
    }

    protected Map<String, String[]> params() {
        return RequestUtils.params();
    }

    protected List<String> params(String name, List<FormItem> formItems) {
        return RequestUtils.params(name, formItems);
    }

    public Map<String, String> getMap(String hashName) {
        Map<String, String[]> params = this.params();
        HashMap<String, String> hash = new HashMap<String, String>();
        for (String key : params.keySet()) {
            String name;
            if (!key.startsWith(hashName) || (name = HttpSupport.parseHashName(key)) == null) continue;
            hash.put(name, this.param(key));
        }
        return hash;
    }

    public Map<String, String> getMap(String hashName, List<FormItem> formItems) {
        HashMap<String, String> hash = new HashMap<String, String>();
        for (FormItem item : formItems) {
            String name;
            if (!item.getFieldName().startsWith(hashName) || item.isFile() || (name = HttpSupport.parseHashName(item.getFieldName())) == null) continue;
            hash.put(name, item.getStreamAsString());
        }
        return hash;
    }

    private static String parseHashName(String param) {
        Matcher matcher = hashPattern.matcher(param);
        String name = null;
        while (matcher.find()) {
            name = matcher.group(0);
        }
        return name == null ? null : name.substring(1, name.length() - 1);
    }

    protected void setRequestEncoding(String encoding) throws UnsupportedEncodingException {
        Context.getHttpRequest().setCharacterEncoding(encoding);
    }

    protected void setResponseEncoding(String encoding) {
        Context.getHttpResponse().setCharacterEncoding(encoding);
    }

    protected void setEncoding(String encoding) {
        Context.setEncoding(encoding);
    }

    protected void encoding(String encoding) {
        this.setEncoding(encoding);
    }

    protected String getEncoding() {
        return null;
    }

    protected void setContentLength(int length) {
        Context.getHttpResponse().setContentLength(length);
    }

    protected void setLocale(Locale locale) {
        Context.getHttpResponse().setLocale(locale);
    }

    protected void locale(Locale locale) {
        Context.getHttpResponse().setLocale(locale);
    }

    protected Locale locale() {
        return RequestUtils.locale();
    }

    protected Locale getLocale() {
        return RequestUtils.getLocale();
    }

    protected Map<String, String> params1st() {
        return RequestUtils.params1st();
    }

    protected Map<String, String> params1st(List<FormItem> formItems) {
        return RequestUtils.params1st(formItems);
    }

    protected SessionFacade session() {
        return new SessionFacade();
    }

    protected void session(String name, Serializable value) {
        this.session().put(name, value);
    }

    protected Object sessionObject(String name) {
        return this.session(name);
    }

    protected Object session(String name) {
        Object val = this.session().get(name);
        return val == null ? null : val;
    }

    protected String sessionString(String name) {
        return Convert.toString((Object)this.session(name));
    }

    protected Integer sessionInteger(String name) {
        return Convert.toInteger((Object)this.session(name));
    }

    protected Boolean sessionBoolean(String name) {
        return Convert.toBoolean((Object)this.session(name));
    }

    protected Double sessionDouble(String name) {
        return Convert.toDouble((Object)this.session(name));
    }

    protected Float sessionFloat(String name) {
        return Convert.toFloat((Object)this.session(name));
    }

    protected Long sessionLong(String name) {
        return Convert.toLong((Object)this.session(name));
    }

    protected boolean sessionHas(String name) {
        return this.session().get(name) != null;
    }

    public List<Cookie> cookies() {
        return RequestUtils.cookies();
    }

    public Cookie cookie(String name) {
        return RequestUtils.cookie(name);
    }

    protected String cookieValue(String name) {
        return RequestUtils.cookieValue(name);
    }

    public void sendCookie(Cookie cookie) {
        Context.getHttpResponse().addCookie(Cookie.toServletCookie(cookie));
    }

    public void sendCookie(String name, String value) {
        Context.getHttpResponse().addCookie(Cookie.toServletCookie(new Cookie(name, value)));
    }

    public void sendPermanentCookie(String name, String value) {
        Cookie cookie = new Cookie(name, value);
        cookie.setMaxAge(630720000);
        Context.getHttpResponse().addCookie(Cookie.toServletCookie(cookie));
    }

    protected String path() {
        return RequestUtils.path();
    }

    protected String url() {
        return RequestUtils.url();
    }

    protected String queryString() {
        return RequestUtils.queryString();
    }

    protected String method() {
        return RequestUtils.method();
    }

    protected boolean isGet() {
        return RequestUtils.isGet();
    }

    protected boolean isPost() {
        return RequestUtils.isPost();
    }

    protected boolean isPut() {
        return RequestUtils.isPut();
    }

    protected boolean isDelete() {
        return RequestUtils.isDelete();
    }

    private boolean isMethod(String method) {
        return RequestUtils.isMethod(method);
    }

    protected boolean isHead() {
        return RequestUtils.isHead();
    }

    protected String context() {
        return RequestUtils.context();
    }

    protected String uri() {
        return RequestUtils.uri();
    }

    protected String remoteHost() {
        return RequestUtils.remoteHost();
    }

    protected String remoteAddress() {
        return RequestUtils.remoteAddress();
    }

    protected String header(String name) {
        return RequestUtils.header(name);
    }

    protected Map<String, String> headers() {
        return RequestUtils.headers();
    }

    protected void header(String name, String value) {
        Context.getHttpResponse().addHeader(name, value);
    }

    protected void header(String name, Object value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.header(name, value.toString());
    }

    protected HttpBuilder streamOut(InputStream in) {
        StreamResponse resp = new StreamResponse(in);
        Context.setControllerResponse(resp);
        return new HttpBuilder(resp);
    }

    protected String getRealPath(String path) {
        return Context.getFilterConfig().getServletContext().getRealPath(path);
    }

    protected OutputStream outputStream() {
        return this.outputStream(null, null, 200);
    }

    protected OutputStream outputStream(String contentType) {
        return this.outputStream(contentType, null, 200);
    }

    protected OutputStream outputStream(String contentType, Map headers, int status) {
        try {
            Context.setControllerResponse(new NopResponse(contentType, status));
            if (headers != null) {
                for (Object key : headers.keySet()) {
                    if (headers.get(key) == null) continue;
                    Context.getHttpResponse().addHeader(key.toString(), headers.get(key).toString());
                }
            }
            return Context.getHttpResponse().getOutputStream();
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    protected PrintWriter writer() {
        return this.writer(null, null, 200);
    }

    protected PrintWriter writer(String contentType, Map headers, int status) {
        try {
            Context.setControllerResponse(new NopResponse(contentType, status));
            if (headers != null) {
                for (Object key : headers.keySet()) {
                    if (headers.get(key) == null) continue;
                    Context.getHttpResponse().addHeader(key.toString(), headers.get(key).toString());
                }
            }
            return Context.getHttpResponse().getWriter();
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    protected boolean blank(String ... names) {
        for (String name : names) {
            if (!Util.blank((Object)this.param(name))) continue;
            return true;
        }
        return false;
    }

    protected boolean isXhr() {
        return RequestUtils.isXhr();
    }

    protected String userAgent() {
        return RequestUtils.userAgent();
    }

    protected boolean xhr() {
        return RequestUtils.xhr();
    }

    protected AppContext appContext() {
        return RequestUtils.appContext();
    }

    protected String format() {
        return RequestUtils.format();
    }

    protected Route getRoute() {
        return RequestUtils.getRoute();
    }

    protected String merge(String template, Map values) {
        StringWriter stringWriter = new StringWriter();
        Configuration.getTemplateManager().merge(values, template, stringWriter);
        return stringWriter.toString();
    }

    public Map<String, String> getResponseHeaders() {
        Collection names = Context.getHttpResponse().getHeaderNames();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : names) {
            headers.put(name, Context.getHttpResponse().getHeader(name));
        }
        return headers;
    }

    protected String sanitize(String unsafeContent) {
        return Jsoup.clean((String)unsafeContent, (Whitelist)Whitelist.basic());
    }

    protected InputStream getRequestInputStream() throws IOException {
        return Context.getHttpRequest().getInputStream();
    }

    protected InputStream getRequestStream() throws IOException {
        return Context.getHttpRequest().getInputStream();
    }

    protected String getRequestString() throws IOException {
        return Util.read((InputStream)Context.getHttpRequest().getInputStream());
    }

    protected byte[] getRequestBytes() throws IOException {
        return Util.bytes((InputStream)Context.getHttpRequest().getInputStream());
    }

    protected List jsonList() {
        this.checkJsonContentType();
        try {
            return JsonHelper.toList((String)this.getRequestString());
        }
        catch (IOException e) {
            throw new WebException(e);
        }
    }

    private void checkJsonContentType() {
        if (this.header("Content-Type") == null || !this.header("Content-Type").toLowerCase().contains("application/json")) {
            throw new WebException("Trying to convert JSON to object, but Content-Type is " + this.header("Content-Type") + ", not 'application/json'");
        }
    }

    protected Map jsonMap() {
        this.checkJsonContentType();
        try {
            return JsonHelper.toMap((String)this.getRequestString());
        }
        catch (IOException e) {
            throw new WebException(e);
        }
    }

    protected Map[] jsonMaps() {
        this.checkJsonContentType();
        try {
            return JsonHelper.toMaps((String)this.getRequestString());
        }
        catch (IOException e) {
            throw new WebException(e);
        }
    }

    public class RenderBuilder
    extends HttpBuilder {
        private RenderBuilder(RenderTemplateResponse response) {
            super(response);
        }

        public RenderBuilder layout(String layout) {
            this.getRenderTemplateResponse().setLayout(layout);
            return this;
        }

        protected RenderTemplateResponse getRenderTemplateResponse() {
            return (RenderTemplateResponse)this.getControllerResponse();
        }

        public RenderBuilder noLayout() {
            this.getRenderTemplateResponse().setLayout(null);
            return this;
        }

        public RenderBuilder format(String format) {
            ControllerResponse response = Context.getControllerResponse();
            if (response instanceof RenderTemplateResponse) {
                ((RenderTemplateResponse)response).setFormat(format);
            }
            return this;
        }
    }

    public class HttpBuilder {
        private ControllerResponse controllerResponse;

        private HttpBuilder(ControllerResponse controllerResponse) {
            this.controllerResponse = controllerResponse;
        }

        protected ControllerResponse getControllerResponse() {
            return this.controllerResponse;
        }

        public HttpBuilder contentType(String contentType) {
            this.controllerResponse.setContentType(contentType);
            return this;
        }

        public HttpBuilder header(String name, String value) {
            Context.getHttpResponse().setHeader(name, value);
            return this;
        }

        public void status(int status) {
            this.controllerResponse.setStatus(status);
        }
    }
}

