/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.activeweb.Configuration;

public class IgnoreSpec {
    private List<Pattern> ignorePatterns = new ArrayList<Pattern>();
    private String exceptEnvironment;

    IgnoreSpec(String[] ignores) {
        for (String ignore : ignores) {
            this.ignorePatterns.add(Pattern.compile(ignore));
        }
    }

    protected boolean ignores(String path) {
        boolean matches = false;
        for (Pattern pattern : this.ignorePatterns) {
            Matcher m = pattern.matcher(path);
            matches = m.matches();
            if (!matches || this.exceptEnvironment == null || !this.exceptEnvironment.equals(Configuration.getEnv())) continue;
            matches = false;
        }
        return matches;
    }

    public void exceptIn(String environment) {
        this.exceptEnvironment = environment;
    }
}

