/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.SessionHelper;
import org.javalite.common.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParamCopy {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ParamCopy.class.getSimpleName());

    private ParamCopy() {
    }

    static void copyInto(Map assigns) {
        ParamCopy.insertActiveWebParamsInto(assigns);
        ParamCopy.copyRequestAttributesInto(assigns);
        ParamCopy.copyRequestParamsInto(assigns);
        ParamCopy.copySessionAttrsInto(assigns);
        ParamCopy.copyRequestProperties(assigns);
    }

    private static void insertActiveWebParamsInto(Map assigns) {
        assigns.put("context_path", Context.getHttpRequest().getContextPath());
        Route route = Context.getRoute();
        Map params = Collections.map((Object[])new Object[]{"environment", Configuration.getEnv()});
        if (route != null) {
            params.put("controller", Context.getRoute().getControllerPath());
            params.put("action", Context.getRoute().getActionName());
            params.put("restful", Context.getRoute().getController().restful());
        }
        assigns.put("activeweb", params);
    }

    private static void copySessionAttrsInto(Map assigns) {
        Map<String, Object> sessionAttrs = SessionHelper.getSessionAttributes();
        if (assigns.get("session") != null) {
            LOGGER.warn("found 'session' value set by controller. It is reserved by ActiveWeb and will be overwritten.");
        }
        if (sessionAttrs.containsKey("flasher")) {
            assigns.put("flasher", sessionAttrs.get("flasher"));
        }
        assigns.put("session", sessionAttrs);
    }

    private static void copyRequestParamsInto(Map assigns) {
        Enumeration names = Context.getHttpRequest().getParameterNames();
        HashMap<String, String> requestParameterMap = new HashMap<String, String>();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            String[] values = Context.getHttpRequest().getParameterValues(name.toString());
            Object value = values != null && values.length == 1 ? values[0] : values;
            if (value == null) continue;
            requestParameterMap.put(name.toString(), value.toString());
        }
        assigns.put("request", requestParameterMap);
    }

    private static void copyRequestAttributesInto(Map assigns) {
        Enumeration names = Context.getHttpRequest().getAttributeNames();
        while (names.hasMoreElements()) {
            Object name = names.nextElement();
            Object value = Context.getHttpRequest().getAttribute(name.toString());
            assigns.put(name, value);
        }
    }

    private static void copyRequestProperties(Map assigns) {
        assigns.put("request_props", Collections.map((Object[])new Object[]{"url", Context.getHttpRequest().getRequestURL().toString()}));
    }
}

