/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.net.URL;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerException;
import org.javalite.activeweb.ControllerResponse;

class RedirectResponse
extends ControllerResponse {
    private URL url;
    private String path;

    protected RedirectResponse(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url can't be null");
        }
        this.url = url;
    }

    protected RedirectResponse(String path) {
        if (path == null) {
            throw new IllegalArgumentException("url can't be null");
        }
        this.path = path;
    }

    @Override
    void doProcess() {
        try {
            if (this.url != null) {
                Context.getHttpResponse().sendRedirect(this.url.toString());
            } else if (this.path != null) {
                Context.getHttpResponse().sendRedirect(this.path);
            }
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    public String redirectValue() {
        return this.path != null ? this.path : this.url.toString();
    }
}

