/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.Map;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerResponse;
import org.javalite.activeweb.TemplateManager;
import org.javalite.activeweb.ViewException;

class RenderTemplateResponse
extends ControllerResponse {
    private Map values;
    private String template;
    private String format;
    private String layout = Configuration.getDefaultLayout();
    private TemplateManager templateManager;
    private boolean defaultLayout = true;

    protected RenderTemplateResponse(Map values, String template, String format) {
        if (template == null) {
            throw new IllegalArgumentException("template cannot be null");
        }
        if (values == null) {
            throw new IllegalArgumentException("values cannot be null");
        }
        this.values = values;
        this.template = template;
        this.format = format;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getLayout() {
        return this.layout;
    }

    @Override
    public Map values() {
        return this.values;
    }

    public void setLayout(String layout) {
        this.layout = layout;
        this.defaultLayout = false;
    }

    public boolean hasDefaultLayout() {
        return this.defaultLayout;
    }

    protected void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    @Override
    void doProcess() {
        try {
            this.templateManager.merge(this.values, this.template, this.layout, this.format, Context.getHttpResponse().getWriter());
        }
        catch (IllegalStateException | ViewException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ViewException(e);
        }
    }

    public String toString() {
        return "RenderTemplateResponse{values=" + this.values + ", template='" + this.template + '\'' + ", layout='" + this.layout + '\'' + '}';
    }

    public void setFormat(String format) {
        this.format = format;
    }
}

