/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javalite.activejdbc.DB;
import org.javalite.activeweb.AbstractRouteConfig;
import org.javalite.activeweb.ActionNotFoundException;
import org.javalite.activeweb.AppConfig;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Bootstrap;
import org.javalite.activeweb.ClassLoadException;
import org.javalite.activeweb.CompilationException;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ConfigurationException;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerRegistry;
import org.javalite.activeweb.ControllerRunner;
import org.javalite.activeweb.DynamicClassFactory;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.InitException;
import org.javalite.activeweb.ParamCopy;
import org.javalite.activeweb.RenderTemplateResponse;
import org.javalite.activeweb.RequestContext;
import org.javalite.activeweb.RequestUtils;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.RouteException;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.SessionHelper;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.ViewMissingException;
import org.javalite.common.Collections;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestDispatcher
implements Filter {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private FilterConfig filterConfig;
    private List<String> exclusions = new ArrayList<String>();
    private ControllerRunner runner = new ControllerRunner();
    private AppContext appContext;
    private Bootstrap appBootstrap;
    private String encoding;
    private AbstractRouteConfig routeConfigTest;
    private boolean testMode;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
        ControllerRegistry registry = new ControllerRegistry(filterConfig);
        filterConfig.getServletContext().setAttribute("controllerRegistry", (Object)registry);
        Configuration.getTemplateManager().setServletContext(filterConfig.getServletContext());
        Context.setControllerRegistry(registry);
        this.appContext = new AppContext();
        filterConfig.getServletContext().setAttribute("appContext", (Object)this.appContext);
        String exclusionsParam = filterConfig.getInitParameter("exclusions");
        if (exclusionsParam != null) {
            this.exclusions.addAll(Arrays.asList(exclusionsParam.split(",")));
            for (int i = 0; i < this.exclusions.size(); ++i) {
                this.exclusions.set(i, this.exclusions.get(i).trim());
            }
        }
        this.initApp(this.appContext);
        this.encoding = filterConfig.getInitParameter("encoding");
        this.logger.info("ActiveWeb: starting the app in environment: " + Configuration.getEnv());
    }

    protected void initApp(AppContext context) {
        this.initAppConfig(Configuration.getBootstrapClassName(), context, true);
        this.initAppConfig(Configuration.getControllerConfigClassName(), context, false);
        this.initAppConfig(Configuration.getDbConfigClassName(), context, false);
    }

    public AppContext getContext() {
        return this.appContext;
    }

    protected void setRouteConfig(AbstractRouteConfig routeConfig) {
        this.routeConfigTest = routeConfig;
        this.testMode = true;
    }

    private Router getRouter(AppContext context) {
        String routeConfigClassName = Configuration.getRouteConfigClassName();
        Router router = new Router(this.filterConfig.getInitParameter("root_controller"));
        try {
            AbstractRouteConfig routeConfigLocal;
            if (this.testMode) {
                routeConfigLocal = this.routeConfigTest;
            } else {
                Class configClass = DynamicClassFactory.getCompiledClass(routeConfigClassName);
                routeConfigLocal = (AbstractRouteConfig)configClass.newInstance();
            }
            routeConfigLocal.clear();
            routeConfigLocal.init(context);
            router.setRoutes(routeConfigLocal.getRoutes());
            router.setIgnoreSpecs(routeConfigLocal.getIgnoreSpecs());
            this.logger.debug("Loaded routes from: " + routeConfigClassName);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.debug("Did not find custom routes. Going with built in defaults: " + RequestDispatcher.getCauseMessage(e));
        }
        return router;
    }

    static String getCauseMessage(Throwable throwable) {
        ArrayList<Throwable> list = new ArrayList<Throwable>();
        while (throwable != null && !list.contains(throwable)) {
            list.add(throwable);
            throwable = throwable.getCause();
        }
        return ((Throwable)list.get(0)).getMessage();
    }

    private void initAppConfig(String configClassName, AppContext context, boolean fail) {
        try {
            Class<?> c = Class.forName(configClassName);
            AppConfig appConfig = (AppConfig)c.newInstance();
            appConfig.init(context);
            if (appConfig instanceof Bootstrap) {
                this.appBootstrap = (Bootstrap)appConfig;
                if (!Configuration.isTesting()) {
                    Injector injector = this.appBootstrap.getInjector();
                    if (injector != null && Context.getControllerRegistry() != null) {
                        this.logger.warn("OVERWRITING CURRENT INJECTOR...");
                    }
                    if (injector != null) {
                        Context.getControllerRegistry().setInjector(injector);
                    }
                }
            }
            appConfig.completeInit();
        }
        catch (Throwable e) {
            if (fail) {
                this.logger.error("Failed to create and init a new instance of class: " + configClassName, e);
                throw new InitException(e);
            }
            this.logger.info("Failed to create and init a new instance of class: " + configClassName + ", proceeding without it.");
        }
    }

    protected ControllerRegistry getControllerRegistry() {
        return (ControllerRegistry)this.filterConfig.getServletContext().getAttribute("controllerRegistry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        try {
            Router router;
            Route route;
            String uri;
            String path;
            HttpServletRequest request = (HttpServletRequest)req;
            HttpServletResponse response = (HttpServletResponse)resp;
            if (this.encoding != null) {
                this.logger.debug("Setting encoding: " + this.encoding);
                request.setCharacterEncoding(this.encoding);
                response.setCharacterEncoding(this.encoding);
            }
            if (this.excluded(path = request.getServletPath())) {
                chain.doFilter(req, resp);
                this.logger.debug("URI excluded: " + path);
                return;
            }
            String format = null;
            if (path.contains(".")) {
                uri = path.substring(0, path.lastIndexOf(46));
                format = path.substring(path.lastIndexOf(46) + 1);
            } else {
                uri = path;
            }
            Context.setTLs(request, response, this.filterConfig, this.getControllerRegistry(), this.appContext, new RequestContext(), format);
            if (Util.blank((Object)uri)) {
                uri = "/";
            }
            if ((route = (router = this.getRouter(this.appContext)).recognize(uri, HttpMethod.getMethod(request))).ignores(path)) {
                chain.doFilter(req, resp);
                this.logger.debug("URI ignored: " + path);
                return;
            }
            if (route != null) {
                Context.setRoute(route);
                if (Configuration.logRequestParams()) {
                    this.logger.info("================ New request: " + new Date() + " ================");
                }
                this.runner.run(route, true);
            } else {
                this.logger.warn("No matching route for servlet path: " + request.getServletPath() + ", passing down to container.");
                chain.doFilter(req, resp);
            }
        }
        catch (CompilationException e) {
            this.renderSystemError(e);
        }
        catch (ActionNotFoundException | ClassLoadException e) {
            this.renderSystemError("/system/404", Configuration.useDefaultLayoutForErrors() ? Configuration.getDefaultLayout() : null, 404, e);
        }
        catch (RouteException | ViewMissingException e) {
            this.renderSystemError("/system/404", Configuration.useDefaultLayoutForErrors() ? Configuration.getDefaultLayout() : null, 404, e);
        }
        catch (ViewException e) {
            this.renderSystemError("/system/error", Configuration.useDefaultLayoutForErrors() ? Configuration.getDefaultLayout() : null, 500, e);
        }
        catch (Throwable e) {
            this.renderSystemError("/system/error", Configuration.useDefaultLayoutForErrors() ? Configuration.getDefaultLayout() : null, 500, e);
        }
        finally {
            Context.clear();
            List connectionsRemaining = DB.getCurrrentConnectionNames();
            if (!connectionsRemaining.isEmpty()) {
                this.logger.warn("CONNECTION LEAK DETECTED ... and AVERTED!!! You left connections opened:" + connectionsRemaining + ". ActiveWeb is closing all active connections for you...");
                DB.closeAllConnections();
            }
        }
    }

    private Map getMapWithExceptionDataAndSession(Throwable e) {
        return Collections.map((Object[])new Object[]{"message", e.getMessage() == null ? e.toString() : e.getMessage(), "stack_trace", this.getStackTraceString(e), "session", SessionHelper.getSessionAttributes()});
    }

    private boolean excluded(String servletPath) {
        for (String exclusion : this.exclusions) {
            if (!servletPath.contains(exclusion)) continue;
            return true;
        }
        return false;
    }

    private void renderSystemError(Throwable e) {
        this.renderSystemError("/system/error", null, 500, e);
    }

    private String getStackTraceString(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    private void renderSystemError(String template, String layout, int status, Throwable e) {
        try {
            String requestedWith;
            String info = "Request properties: " + RequestUtils.getRequestProperties() + "\n" + "Request parameters: " + RequestUtils.params() + "\n" + "Request headers: " + RequestUtils.headers() + "\n";
            if (status == 404) {
                this.logger.warn("ActiveWeb 404 WARNING: \n" + info + e);
            } else {
                this.logger.error("ActiveWeb ERROR: \n" + info, e);
            }
            HttpServletRequest req = Context.getHttpRequest();
            String string = requestedWith = req.getHeader("x-requested-with") == null ? req.getHeader("X-Requested-With") : req.getHeader("x-requested-with");
            if (requestedWith != null && requestedWith.equalsIgnoreCase("XMLHttpRequest")) {
                try {
                    Context.getHttpResponse().setStatus(status);
                    Context.getHttpResponse().getWriter().write(this.getStackTraceString(e));
                }
                catch (Exception ex) {
                    this.logger.error("Failed to send error response to client", (Throwable)ex);
                }
            } else {
                RenderTemplateResponse resp = new RenderTemplateResponse(this.getMapWithExceptionDataAndSession(e), template, null);
                resp.setLayout(layout);
                resp.setContentType("text/html");
                resp.setStatus(status);
                resp.setTemplateManager(Configuration.getTemplateManager());
                ParamCopy.copyInto(resp.values());
                resp.process();
            }
        }
        catch (Throwable t) {
            if (t instanceof IllegalStateException) {
                this.logger.error("Failed to render a template: '" + template + "' because templates are rendered with Writer, but you probably already used OutputStream");
            } else {
                this.logger.error("ActiveWeb internal error: ", t);
            }
            try {
                Context.getHttpResponse().getOutputStream().print("<div style='background-color:pink;'>internal error</div>");
            }
            catch (Exception ex) {
                this.logger.error(ex.toString(), (Throwable)ex);
            }
        }
    }

    public void destroy() {
        if (this.appBootstrap != null) {
            this.appBootstrap.destroy(this.appContext);
        }
    }
}

