/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.FormItem;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.SimpleHash;
import org.javalite.common.Collections;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RequestUtils.class.getSimpleName());

    private RequestUtils() {
    }

    public static String param(String name) {
        if (name.equals("id")) {
            return RequestUtils.getId();
        }
        if (Context.getRequestContext().getUserSegments().get(name) != null) {
            return Context.getRequestContext().getUserSegments().get(name);
        }
        if (Context.getRequestContext().getWildCardName() != null && name.equals(Context.getRequestContext().getWildCardName())) {
            return Context.getRequestContext().getWildCardValue();
        }
        return Context.getHttpRequest().getParameter(name);
    }

    public static String param(String name, List<FormItem> formItems) {
        for (FormItem formItem : formItems) {
            if (!formItem.isFormField() || !formItem.getFieldName().equals(name)) continue;
            return formItem.getStreamAsString();
        }
        return null;
    }

    public static String getId() {
        Object id;
        String paramId = Context.getHttpRequest().getParameter("id");
        if (paramId != null && Context.getHttpRequest().getAttribute("id") != null) {
            LOGGER.warn("WARNING: probably you have 'id' supplied both as a HTTP parameter, as well as in the URI. Choosing parameter over URI value.");
        }
        String theId = paramId != null ? paramId : ((id = Context.getHttpRequest().getAttribute("id")) != null ? id.toString() : null);
        return Util.blank((Object)theId) ? null : theId;
    }

    public static String format() {
        return Context.getFormat();
    }

    public static AppContext appContext() {
        return Context.getAppContext();
    }

    public static boolean isXhr() {
        String xhr = RequestUtils.header("X-Requested-With");
        if (xhr == null) {
            xhr = RequestUtils.header("x-requested-with");
        }
        return xhr != null && xhr.toLowerCase().equals("xmlhttprequest");
    }

    public static String userAgent() {
        String camel = RequestUtils.header("User-Agent");
        return camel != null ? camel : RequestUtils.header("user-agent");
    }

    public static boolean xhr() {
        return RequestUtils.isXhr();
    }

    public static Route getRoute() {
        return Context.getRoute();
    }

    public static boolean exists(String name) {
        return RequestUtils.param(name) != null;
    }

    public static boolean requestHas(String name) {
        return RequestUtils.param(name) != null;
    }

    public static String host() {
        return Context.getHttpRequest().getLocalName();
    }

    public static String ipAddress() {
        return Context.getHttpRequest().getLocalAddr();
    }

    public static String getRequestProtocol() {
        String protocol = RequestUtils.header("X-Forwarded-Proto");
        return Util.blank((Object)protocol) ? RequestUtils.protocol() : protocol;
    }

    public static int getRequestPort() {
        String port = RequestUtils.header("X-Forwarded-Port");
        return Util.blank((Object)port) ? RequestUtils.port() : Integer.parseInt(port);
    }

    public static int port() {
        return Context.getHttpRequest().getLocalPort();
    }

    public static String protocol() {
        return Context.getHttpRequest().getProtocol();
    }

    public static String getRequestHost() {
        String forwarded = RequestUtils.header("X-Forwarded-Host");
        if (Util.blank((Object)forwarded)) {
            return RequestUtils.host();
        }
        String[] forwards = forwarded.split(",");
        return forwards[0].trim();
    }

    public static String ipForwardedFor() {
        String h = RequestUtils.header("X-Forwarded-For");
        return !Util.blank((Object)h) ? h : RequestUtils.remoteAddress();
    }

    public static List<String> params(String name) {
        Object[] values = Context.getHttpRequest().getParameterValues(name);
        List<Object> valuesList = null;
        if (name.equals("id")) {
            if (values.length == 1) {
                valuesList = java.util.Collections.singletonList(values[0]);
            } else if (values.length > 1) {
                valuesList = Arrays.asList(values);
            }
        } else {
            valuesList = values == null ? new ArrayList() : Collections.list((Object[])values);
            String userSegment = Context.getRequestContext().getUserSegments().get(name);
            if (userSegment != null) {
                valuesList.add(userSegment);
            }
        }
        return valuesList;
    }

    public static List<String> params(String name, List<FormItem> formItems) {
        ArrayList<String> vals = new ArrayList<String>();
        for (FormItem formItem : formItems) {
            if (!formItem.isFormField() || !formItem.getFieldName().equals(name)) continue;
            vals.add(formItem.getStreamAsString());
        }
        return vals;
    }

    public static Map<String, String> params1st() {
        HashMap<String, String> params = new HashMap<String, String>();
        Enumeration names = Context.getHttpRequest().getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            params.put(name, Context.getHttpRequest().getParameter(name));
        }
        if (RequestUtils.getId() != null) {
            params.put("id", RequestUtils.getId());
        }
        Map<String, String> userSegments = Context.getRequestContext().getUserSegments();
        params.putAll(userSegments);
        return params;
    }

    public static Map<String, String> params1st(List<FormItem> formItems) {
        HashMap<String, String> vals = new HashMap<String, String>();
        for (FormItem formItem : formItems) {
            if (!formItem.isFormField() || vals.containsKey(formItem.getFieldName())) continue;
            vals.put(formItem.getFieldName(), formItem.getStreamAsString());
        }
        return vals;
    }

    public static Map<String, String[]> params() {
        SimpleHash params = new SimpleHash(Context.getHttpRequest().getParameterMap());
        if (RequestUtils.getId() != null) {
            params.put("id", new String[]{RequestUtils.getId()});
        }
        Map<String, String> userSegments = Context.getRequestContext().getUserSegments();
        for (String name : userSegments.keySet()) {
            params.put(name, new String[]{userSegments.get(name)});
        }
        return params;
    }

    public static Locale locale() {
        return Context.getHttpRequest().getLocale();
    }

    public static Locale getLocale() {
        return Context.getHttpRequest().getLocale();
    }

    public static List<Cookie> cookies() {
        javax.servlet.http.Cookie[] servletCookies = Context.getHttpRequest().getCookies();
        if (servletCookies == null) {
            return new ArrayList<Cookie>();
        }
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        for (javax.servlet.http.Cookie servletCookie : servletCookies) {
            Cookie cookie = Cookie.fromServletCookie(servletCookie);
            cookies.add(cookie);
        }
        return cookies;
    }

    public static Cookie cookie(String name) {
        javax.servlet.http.Cookie[] servletCookies = Context.getHttpRequest().getCookies();
        if (servletCookies != null) {
            for (javax.servlet.http.Cookie servletCookie : servletCookies) {
                if (!servletCookie.getName().equals(name)) continue;
                return Cookie.fromServletCookie(servletCookie);
            }
        }
        return null;
    }

    public static String cookieValue(String name) {
        return RequestUtils.cookie(name).getValue();
    }

    public static String path() {
        return Context.getHttpRequest().getServletPath();
    }

    public static String url() {
        return Context.getHttpRequest().getRequestURL().toString();
    }

    public static String queryString() {
        return Context.getHttpRequest().getQueryString();
    }

    public static String method() {
        return Context.getHttpRequest().getMethod();
    }

    public static boolean isGet() {
        return RequestUtils.isMethod("get");
    }

    public static boolean isPost() {
        return RequestUtils.isMethod("post");
    }

    public static boolean isPut() {
        return RequestUtils.isMethod("put");
    }

    public static boolean isDelete() {
        return RequestUtils.isMethod("delete");
    }

    public static boolean isMethod(String method) {
        return HttpMethod.getMethod(Context.getHttpRequest()).name().equalsIgnoreCase(method);
    }

    public static boolean isHead() {
        return RequestUtils.isMethod("head");
    }

    public static String context() {
        return Context.getHttpRequest().getContextPath();
    }

    public static String uri() {
        return Context.getHttpRequest().getRequestURI();
    }

    public static String remoteHost() {
        return Context.getHttpRequest().getRemoteHost();
    }

    public static String remoteAddress() {
        return Context.getHttpRequest().getRemoteAddr();
    }

    public static String header(String name) {
        return Context.getHttpRequest().getHeader(name);
    }

    public static Map<String, String> headers() {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration names = Context.getHttpRequest().getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            headers.put(name, Context.getHttpRequest().getHeader(name));
        }
        return headers;
    }

    public static String getRequestProperties() {
        StringBuilder sb = new StringBuilder();
        HttpServletRequest request = Context.getHttpRequest();
        sb.append("Request URL: ").append(request.getRequestURL()).append("\n");
        sb.append("ContextPath: ").append(request.getContextPath()).append("\n");
        sb.append("Query String: ").append(request.getQueryString()).append("\n");
        sb.append("URI Full Path: ").append(request.getRequestURI()).append("\n");
        sb.append("URI Path: ").append(request.getServletPath()).append("\n");
        sb.append("Method: ").append(request.getMethod()).append("\n");
        return sb.toString();
    }
}

