/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.List;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.IgnoreSpec;
import org.javalite.activeweb.RouteBuilder;
import org.javalite.activeweb.Router;

public class Route {
    private AppController controller;
    private String actionName;
    private String id;
    private String wildCardName;
    private String wildCardValue;
    private List<IgnoreSpec> ignoreSpecs;

    public Route(AppController controller, String actionName) {
        this.controller = controller;
        this.actionName = actionName;
    }

    public Route(AppController controller, String actionName, String id) {
        this.controller = controller;
        this.actionName = actionName;
        this.id = id;
    }

    public Route(RouteBuilder builder) {
        this.controller = builder.getController();
        this.actionName = builder.getActionName();
        this.id = builder.getId();
        this.wildCardName = builder.getWildcardName();
        this.wildCardValue = builder.getWildCardValue();
    }

    public Route(AppController controller) {
        this.controller = controller;
    }

    public boolean isWildCard() {
        return this.wildCardName != null;
    }

    public String getWildCardName() {
        return this.wildCardName;
    }

    public String getWildCardValue() {
        return this.wildCardValue;
    }

    public AppController getController() {
        return this.controller;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getId() {
        return this.id;
    }

    protected String getControllerPath() {
        return Router.getControllerPath(this.controller.getClass());
    }

    protected String getControllerClassName() {
        return this.controller.getClass().getName();
    }

    protected void setIgnoreSpecs(List<IgnoreSpec> ignoreSpecs) {
        this.ignoreSpecs = ignoreSpecs;
    }

    protected boolean ignores(String path) {
        if (this.ignoreSpecs == null) {
            return false;
        }
        for (IgnoreSpec ignoreSpec : this.ignoreSpecs) {
            if (!ignoreSpec.ignores(path)) continue;
            return true;
        }
        return false;
    }
}

