/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.ClassLoadException;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.ConfigurationException;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerException;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.DynamicClassFactory;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.Router;
import org.javalite.common.Util;

public class RouteBuilder {
    private static Pattern USER_SEGMENT_PATTERN = Pattern.compile("\\{.*\\}");
    private String actionName;
    private String id;
    private String routeConfig;
    private AppController controller;
    private Class<? extends AppController> type;
    private List<Segment> segments = new ArrayList<Segment>();
    private List<HttpMethod> methods = new ArrayList<HttpMethod>();
    private String wildcardName;
    private String wildCardValue;
    private int mandatorySegmentCount;

    protected RouteBuilder(AppController controller, String actionName, String id) {
        this.controller = controller;
        this.actionName = actionName;
        this.id = id;
    }

    protected RouteBuilder(AppController controller, String actionName) {
        this(controller, actionName, null);
    }

    protected RouteBuilder(String routeConfig) {
        String[] segmentsArr = Util.split((String)routeConfig, (char)'/');
        for (String segmentStr : segmentsArr) {
            Segment segment = new Segment(segmentStr);
            this.segments.add(segment);
            if (!segment.wildCard) continue;
            String wildCardSegment = segment.segment;
            this.wildcardName = wildCardSegment.substring(1);
            break;
        }
        if (segmentsArr.length > this.segments.size()) {
            throw new ConfigurationException("Cannot have URI segments past wild card");
        }
        this.routeConfig = routeConfig;
        for (Segment segment : this.segments) {
            if (!segment.mandatory) continue;
            ++this.mandatorySegmentCount;
        }
    }

    public boolean isWildcard() {
        return this.wildcardName != null;
    }

    public String getWildcardName() {
        return this.wildcardName;
    }

    public String getWildCardValue() {
        return this.wildCardValue;
    }

    public <T extends AppController> RouteBuilder to(Class<T> type) {
        boolean hasControllerSegment = false;
        for (Segment segment : this.segments) {
            hasControllerSegment = segment.controller;
        }
        if (type != null && hasControllerSegment) {
            throw new IllegalArgumentException("Cannot combine {controller} segment and .to(\"...\") method. Failed route: " + this.routeConfig);
        }
        this.type = type;
        return this;
    }

    public RouteBuilder action(String action) {
        boolean hasActionSegment = false;
        for (Segment segment : this.segments) {
            hasActionSegment = segment.action;
        }
        if (action != null && hasActionSegment) {
            throw new IllegalArgumentException("Cannot combine {action} segment and .action(\"...\") method. Failed route: " + this.routeConfig);
        }
        this.actionName = action;
        return this;
    }

    public RouteBuilder get() {
        if (!this.methods.contains((Object)HttpMethod.GET)) {
            this.methods.add(HttpMethod.GET);
        }
        return this;
    }

    public RouteBuilder post() {
        if (!this.methods.contains((Object)HttpMethod.POST)) {
            this.methods.add(HttpMethod.POST);
        }
        return this;
    }

    public RouteBuilder put() {
        if (!this.methods.contains((Object)HttpMethod.PUT)) {
            this.methods.add(HttpMethod.PUT);
        }
        return this;
    }

    public RouteBuilder delete() {
        if (!this.methods.contains((Object)HttpMethod.DELETE)) {
            this.methods.add(HttpMethod.DELETE);
        }
        return this;
    }

    protected String getActionName() {
        return this.actionName == null ? (this.actionName = "index") : this.actionName;
    }

    protected String getId() {
        return this.id;
    }

    protected AppController getController() {
        try {
            return this.controller == null ? (this.controller = this.type.newInstance()) : this.controller;
        }
        catch (Exception e) {
            throw new ControllerException(e);
        }
    }

    protected boolean matches(String requestUri, HttpMethod httpMethod) throws ClassLoadException {
        boolean match = false;
        String[] requestUriSegments = Util.split((String)requestUri, (char)'/');
        if (this.isWildcard() && requestUriSegments.length >= this.segments.size() && this.wildSegmentsMatch(requestUriSegments)) {
            String[] tailArr = Arrays.copyOfRange(requestUriSegments, this.segments.size() - 1, requestUriSegments.length);
            this.wildCardValue = Util.join((String[])tailArr, (String)"/");
            match = true;
        } else if (this.segments.isEmpty() && requestUri.equals("/")) {
            this.actionName = "index";
            match = true;
        } else if (requestUriSegments.length < this.mandatorySegmentCount || requestUriSegments.length > this.segments.size()) {
            match = false;
        } else {
            for (int i = 0; i < requestUriSegments.length; ++i) {
                String requestUriSegment = requestUriSegments[i];
                match = this.segments.get(i).match(requestUriSegment);
                if (!match) break;
            }
        }
        if (match && Configuration.activeReload()) {
            this.controller = this.reloadController();
        }
        return match && this.methodMatches(httpMethod);
    }

    private boolean wildSegmentsMatch(String[] requestUriSegments) throws ClassLoadException {
        for (int i = 0; i < this.segments.size() - 1; ++i) {
            Segment segment = this.segments.get(i);
            if (segment.match(requestUriSegments[i])) continue;
            return false;
        }
        return true;
    }

    private boolean methodMatches(HttpMethod httpMethod) {
        return this.methods.isEmpty() && httpMethod.equals((Object)HttpMethod.GET) || this.methods.contains((Object)httpMethod);
    }

    private AppController reloadController() throws ClassLoadException {
        try {
            return ControllerFactory.createControllerInstance(this.getController().getClass().getName());
        }
        catch (ClassLoadException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClassLoadException(e);
        }
    }

    protected String getUserSegmentName(String segment) {
        Matcher m = USER_SEGMENT_PATTERN.matcher(segment);
        if (m.find()) {
            String value = m.group(0);
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    private class Segment {
        private String segment;
        private String userSegmentName;
        private boolean controller;
        private boolean action;
        private boolean id;
        private boolean user;
        private boolean mandatory = true;
        private boolean staticSegment;
        private boolean wildCard;

        Segment(String segment) {
            this.segment = segment;
            this.controller = segment.equals("{controller}");
            this.action = segment.equals("{action}");
            this.id = segment.equals("{id}");
            if (!(this.controller || this.action || this.id)) {
                this.userSegmentName = RouteBuilder.this.getUserSegmentName(segment);
                boolean bl = this.user = this.userSegmentName != null;
            }
            if (!(this.controller || this.action || this.id || this.user)) {
                this.staticSegment = true;
            }
            if (segment.startsWith("*")) {
                this.wildCard = true;
            }
        }

        boolean match(String requestSegment) throws ClassLoadException {
            if (this.staticSegment && requestSegment.equals(this.segment)) {
                return true;
            }
            if (this.controller) {
                if (RouteBuilder.this.type == null) {
                    String controllerClassName = ControllerFactory.getControllerClassName("/" + requestSegment);
                    RouteBuilder.this.type = DynamicClassFactory.getCompiledClass(controllerClassName);
                    return true;
                }
                return requestSegment.equals(Router.getControllerPath(RouteBuilder.this.type).substring(1));
            }
            if (this.action) {
                RouteBuilder.this.actionName = requestSegment;
                return true;
            }
            if (this.id) {
                RouteBuilder.this.id = requestSegment;
                return true;
            }
            if (this.user && this.userSegmentName != null) {
                Context.getRequestContext().getUserSegments().put(this.userSegmentName, requestSegment);
                return true;
            }
            return false;
        }
    }
}

