/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.ClassLoadException;
import org.javalite.activeweb.Context;
import org.javalite.activeweb.ControllerException;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.ControllerRegistry;
import org.javalite.activeweb.HttpMethod;
import org.javalite.activeweb.IgnoreSpec;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.RouteBuilder;
import org.javalite.activeweb.RouteException;
import org.javalite.common.Collections;
import org.javalite.common.Inflector;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router {
    private static Logger logger = LoggerFactory.getLogger(Router.class);
    private static final Logger LOGGER = LoggerFactory.getLogger((String)Router.class.getSimpleName());
    public static final String CONTROLLER_NAME = "controller_name";
    public static final String PACKAGE_SUFFIX = "package_suffix";
    private String rootControllerName;
    private List<RouteBuilder> routes = new ArrayList<RouteBuilder>();
    private List<IgnoreSpec> ignoreSpecs;

    protected Router(String rootControllerName) {
        this.rootControllerName = rootControllerName;
    }

    public void setRoutes(List<RouteBuilder> routes) {
        this.routes = routes;
    }

    protected Route recognize(String uri, HttpMethod httpMethod) throws ClassLoadException {
        Route route = this.matchCustom(uri, httpMethod);
        if (route == null) {
            Map<String, String> controllerPath = this.getControllerPath(uri);
            String controllerName = controllerPath.get(CONTROLLER_NAME);
            String packageSuffix = controllerPath.get(PACKAGE_SUFFIX);
            if (controllerName == null) {
                return null;
            }
            String controllerClassName = ControllerFactory.getControllerClassName(controllerName, packageSuffix);
            AppController controller = ControllerFactory.createControllerInstance(controllerClassName);
            if (uri.equals("/") && this.rootControllerName != null && httpMethod.equals((Object)HttpMethod.GET)) {
                route = new Route(controller, "index");
            } else {
                Route route2 = route = controller.restful() ? this.matchRestful(uri, controllerName, packageSuffix, httpMethod, controller) : this.matchStandard(uri, controllerName, packageSuffix, controller);
            }
        }
        if (route == null) {
            logger.error("Failed to recognize URL: '" + uri + "'");
            throw new RouteException("Failed to map resource to URI: " + uri);
        }
        route.setIgnoreSpecs(this.ignoreSpecs);
        return route;
    }

    private Route matchCustom(String uri, HttpMethod httpMethod) throws ClassLoadException {
        for (RouteBuilder builder : this.routes) {
            if (!builder.matches(uri, httpMethod)) continue;
            return new Route(builder);
        }
        return null;
    }

    private Route matchStandard(String uri, String controllerName, String packageSuffix, AppController controller) {
        String theUri;
        String controllerPath = (packageSuffix != null ? "/" + packageSuffix.replace(".", "/") : "") + "/" + controllerName;
        String string = theUri = uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
        if (controllerPath.length() == theUri.length()) {
            return new Route(controller, "index");
        }
        String tail = theUri.substring(controllerPath.length() + 1);
        String[] parts = Router.split(tail, "/");
        if (parts.length == 1) {
            return new Route(controller, parts[0]);
        }
        if (parts.length == 2) {
            return new Route(controller, parts[0], parts[1]);
        }
        LOGGER.warn("Failed to find action for request: " + uri);
        return null;
    }

    private Route matchRestful(String uri, String controllerName, String packageSuffix, HttpMethod httpMethod, AppController controller) {
        String theUri = uri.endsWith("/") ? uri.substring(0, uri.length() - 1) : uri;
        String controllerPath = (packageSuffix != null ? "/" + packageSuffix.replace(".", "/") : "") + "/" + controllerName;
        String tail = theUri.length() > controllerPath.length() ? theUri.substring(controllerPath.length() + 1) : "";
        String[] parts = Router.split(tail, "/");
        if (controllerPath.equals(theUri) && httpMethod.equals((Object)HttpMethod.GET)) {
            return new Route(controller, "index");
        }
        if (parts.length == 1 && httpMethod.equals((Object)HttpMethod.GET) && parts[0].equalsIgnoreCase("new_form")) {
            return new Route(controller, "new_form");
        }
        if (parts.length == 0 && httpMethod.equals((Object)HttpMethod.POST)) {
            return new Route(controller, "create");
        }
        if (parts.length == 1 && httpMethod.equals((Object)HttpMethod.GET)) {
            return new Route(controller, "show", parts[0]);
        }
        if (parts.length == 2 && httpMethod.equals((Object)HttpMethod.GET) && parts[1].equalsIgnoreCase("edit_form")) {
            return new Route(controller, "edit_form", parts[0]);
        }
        if (parts.length == 1 && httpMethod.equals((Object)HttpMethod.PUT)) {
            return new Route(controller, "update", parts[0]);
        }
        if (parts.length == 1 && httpMethod.equals((Object)HttpMethod.DELETE)) {
            return new Route(controller, "destroy", parts[0]);
        }
        if (parts.length == 0 && httpMethod.equals((Object)HttpMethod.OPTIONS)) {
            return new Route(controller, "options");
        }
        LOGGER.warn("Failed to find action for request: " + uri);
        return null;
    }

    public static String generate(String controllerPath, String action, String id, boolean restful, Map params) {
        StringBuilder uri = new StringBuilder(controllerPath.startsWith("/") ? controllerPath : "/" + controllerPath);
        if (restful) {
            if (action != null && !action.equals("new_form") && !action.equals("edit_form")) {
                throw new IllegalArgumentException("Illegal action name: '" + action + "', allowed names for restful controllers: 'new_form' and 'edit_form'");
            }
            if (action != null && action.equals("new_form") && id != null) {
                throw new IllegalArgumentException("Cannot provide ID to action 'new_form'");
            }
            if (action != null && action.equals("edit_form") && id == null) {
                throw new IllegalArgumentException("Must provide ID to action 'edit_form'");
            }
            if (id != null) {
                uri.append("/").append(id);
            }
            if (action != null) {
                uri.append("/").append(action);
            }
        } else {
            if (action != null) {
                uri.append("/").append(action);
            }
            if (id != null) {
                uri.append("/").append(id);
            }
        }
        if (params.size() > 0) {
            uri.append("?");
        }
        ArrayList<String> pairs = new ArrayList<String>();
        for (Object key : params.keySet()) {
            try {
                pairs.add(URLEncoder.encode(key.toString(), "UTF-8") + "=" + URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
            catch (Exception e) {
                pairs.add(URLEncoder.encode(key.toString()) + "=" + URLEncoder.encode(params.get(key).toString()));
            }
        }
        java.util.Collections.sort(pairs, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        Util.join((StringBuilder)uri, pairs, (String)"&");
        return uri.toString();
    }

    protected Map<String, String> getControllerPath(String uri) {
        boolean useRootController;
        boolean rootPath = uri.equals("/");
        boolean bl = useRootController = rootPath && this.rootControllerName != null;
        if (useRootController) {
            return Collections.map((Object[])new Object[]{CONTROLLER_NAME, this.rootControllerName});
        }
        if (this.rootControllerName == null && rootPath) {
            LOGGER.warn("URI is: '/', but root controller not set");
            return new HashMap<String, String>();
        }
        String pack = this.findPackagePrefix(uri);
        if (pack != null) {
            String controllerName = Router.findControllerNamePart(pack, uri);
            return Collections.map((Object[])new Object[]{CONTROLLER_NAME, controllerName, PACKAGE_SUFFIX, pack});
        }
        return Collections.map((Object[])new Object[]{CONTROLLER_NAME, uri.split("/")[1]});
    }

    static <T extends AppController> String getControllerPath(Class<T> controllerClass) {
        String simpleName = controllerClass.getSimpleName();
        if (!simpleName.endsWith("Controller")) {
            throw new ControllerException("controller name must end with 'Controller' suffix");
        }
        String className = controllerClass.getName();
        if (!className.startsWith("app.controllers")) {
            throw new ControllerException("controller must be in the 'app.controllers' package");
        }
        String packageSuffix = className.substring("app.controllers".length(), className.lastIndexOf("."));
        if ((packageSuffix = packageSuffix.replace(".", "/")).startsWith("/")) {
            packageSuffix = packageSuffix.substring(1);
        }
        return (packageSuffix.equals("") ? "" : "/" + packageSuffix) + "/" + Inflector.underscore((String)simpleName.substring(0, simpleName.lastIndexOf("Controller")));
    }

    protected static String findControllerNamePart(String pack, String uri) {
        String temp = uri.startsWith("/") ? uri.substring(1) : uri;
        if ((temp = temp.replace("/", ".")).length() > pack.length()) {
            temp = temp.substring(pack.length() + 1);
        }
        if (temp.equals("") || temp.equals(pack)) {
            throw new ControllerException("You defined a controller package '" + pack + "', but this request does not specify controller name");
        }
        return temp.split("\\.")[0];
    }

    protected String findPackagePrefix(String uri) {
        String temp = uri.startsWith("/") ? uri.substring(1) : uri;
        temp = temp.replace(".", "_");
        temp = temp.replace("/", ".");
        ArrayList<String> candidates = new ArrayList<String>();
        ControllerRegistry r = Context.getControllerRegistry();
        for (String pack : Context.getControllerRegistry().getControllerPackages()) {
            if (!temp.startsWith(pack)) continue;
            candidates.add(pack);
        }
        int resultIndex = 0;
        int size = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            String candidate = (String)candidates.get(i);
            if (candidate.length() <= size) continue;
            size = candidate.length();
            resultIndex = i;
        }
        return !candidates.isEmpty() ? (String)candidates.get(resultIndex) : null;
    }

    private static String[] split(String value, String delimeter) {
        StringTokenizer st = new StringTokenizer(value, delimeter);
        String[] res = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            res[i] = st.nextToken();
            ++i;
        }
        return res;
    }

    public void setIgnoreSpecs(List<IgnoreSpec> ignoreSpecs) {
        this.ignoreSpecs = ignoreSpecs;
    }
}

