/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.controller_filters;

import org.javalite.activeweb.controller_filters.HttpSupportFilter;

public abstract class AbstractLoggingFilter
extends HttpSupportFilter {
    private Level level;

    public AbstractLoggingFilter(Level level) {
        this.level = level;
    }

    public AbstractLoggingFilter() {
        this(Level.INFO);
    }

    public void logAtLevel(Level level) {
        this.level = level;
    }

    @Override
    public final void before() {
        this.log(this.getMessage() + ", session: " + this.session().id());
    }

    protected void log(String message) {
        if (this.level.equals((Object)Level.DISABLED)) {
            return;
        }
        if (this.level.equals((Object)Level.INFO)) {
            this.logInfo(message);
        }
        if (this.level.equals((Object)Level.WARNING)) {
            this.logWarning(message);
        }
        if (this.level.equals((Object)Level.DEBUG)) {
            this.logDebug(message);
        }
        if (this.level.equals((Object)Level.ERROR)) {
            this.logError(message);
        }
    }

    public Level getLevel() {
        return this.level;
    }

    protected abstract String getMessage();

    public static enum Level {
        INFO,
        WARNING,
        DEBUG,
        ERROR,
        DISABLED;

    }
}

