/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.controller_filters;

import java.util.LinkedList;
import java.util.List;
import org.javalite.activejdbc.DB;
import org.javalite.activejdbc.connection_config.ConnectionSpecWrapper;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.InitException;
import org.javalite.activeweb.controller_filters.ControllerFilterAdapter;

public class DBConnectionFilter
extends ControllerFilterAdapter {
    private String dbName;
    private boolean manageTransaction;

    public DBConnectionFilter() {
    }

    public DBConnectionFilter(String dbName) {
        this.dbName = dbName;
    }

    public DBConnectionFilter(String dbName, boolean manageTransaction) {
        this.manageTransaction = manageTransaction;
        this.dbName = dbName;
    }

    @Override
    public void before() {
        if (Configuration.isTesting()) {
            return;
        }
        List<ConnectionSpecWrapper> connectionWrappers = this.getConnectionWrappers();
        if (connectionWrappers.isEmpty()) {
            throw new InitException("There are no connection specs in '" + Configuration.getEnv() + "' environment");
        }
        for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
            DB db = new DB(connectionWrapper.getDbName());
            db.open(connectionWrapper.getConnectionSpec());
            if (!this.manageTransaction) continue;
            db.openTransaction();
        }
    }

    @Override
    public void after() {
        if (Configuration.isTesting()) {
            return;
        }
        List<ConnectionSpecWrapper> connectionWrappers = this.getConnectionWrappers();
        if (connectionWrappers != null && !connectionWrappers.isEmpty()) {
            for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
                DB db = new DB(connectionWrapper.getDbName());
                if (!db.hasConnection()) continue;
                if (this.manageTransaction) {
                    db.commitTransaction();
                }
                db.close();
            }
        }
    }

    @Override
    public void onException(Exception e) {
        if (Configuration.isTesting()) {
            return;
        }
        List<ConnectionSpecWrapper> connectionWrappers = this.getConnectionWrappers();
        if (connectionWrappers != null && !connectionWrappers.isEmpty()) {
            for (ConnectionSpecWrapper connectionWrapper : connectionWrappers) {
                DB db = new DB(connectionWrapper.getDbName());
                if (!db.hasConnection()) continue;
                if (this.manageTransaction) {
                    db.rollbackTransaction();
                }
                db.close();
            }
        }
    }

    private List<ConnectionSpecWrapper> getConnectionWrappers() {
        List<ConnectionSpecWrapper> allConnections = Configuration.getConnectionSpecWrappers();
        LinkedList<ConnectionSpecWrapper> result = new LinkedList<ConnectionSpecWrapper>();
        for (ConnectionSpecWrapper connectionWrapper : allConnections) {
            if (connectionWrapper.isTesting() || this.dbName != null && !this.dbName.equals(connectionWrapper.getDbName())) continue;
            result.add(connectionWrapper);
        }
        return result;
    }
}

