/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.controller_filters;

import java.util.Map;
import org.javalite.activeweb.controller_filters.AbstractLoggingFilter;

public class HeadersLogFilter
extends AbstractLoggingFilter {
    private boolean printResponseHeaders;

    public HeadersLogFilter(AbstractLoggingFilter.Level level) {
        super(level);
    }

    public HeadersLogFilter(AbstractLoggingFilter.Level level, boolean printResponseHeaders) {
        super(level);
        this.printResponseHeaders = printResponseHeaders;
    }

    public HeadersLogFilter() {
    }

    @Override
    protected String getMessage() {
        return "Request headers: " + this.format(this.headers());
    }

    private String format(Map<String, String> headers) {
        StringBuilder sb = new StringBuilder("{");
        int i = 0;
        for (String header : headers.keySet()) {
            sb.append("\"").append(header).append("\" : \"").append(headers.get(header)).append("\"");
            if (i < headers.size() - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public void after() {
        if (this.printResponseHeaders) {
            String message = this.format(this.getResponseHeaders());
            this.log("Response headers: " + message);
        }
    }
}

