/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.controllers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.javalite.activeweb.AppController;
import org.javalite.common.Util;

public abstract class AbstractLesscController
extends AppController {
    public void index() {
        try {
            this.respond(this.css()).contentType("text/css");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract File getLessFile();

    private synchronized String css() throws Exception {
        File lessFile = this.getLessFile();
        if (!lessFile.exists()) {
            throw new RuntimeException("File: " + lessFile.getPath() + " does not exist. Current directory: " + new File(".").getCanonicalPath());
        }
        String hash = (String)this.appContext().get("hash");
        String freshHash = this.getDirectoryHash(lessFile.getParentFile().getPath());
        if (hash != null && hash.equals(freshHash)) {
            return (String)this.appContext().get("css");
        }
        String css = this.lessc(lessFile);
        this.appContext().set("hash", freshHash);
        this.appContext().set("css", css);
        return css;
    }

    public String lessc(File lessFile) throws IOException, InterruptedException {
        this.logInfo("Executing: lessc " + lessFile.getPath());
        String exec = "lessc";
        if (System.getProperty("os.name").toLowerCase().contains("windows")) {
            exec = exec + ".cmd";
        }
        Process process = Runtime.getRuntime().exec(new String[]{exec, lessFile.getPath()});
        String css = Util.read((InputStream)process.getInputStream(), (String)"UTF-8");
        String error = Util.read((InputStream)process.getErrorStream(), (String)"UTF-8");
        if (process.waitFor() != 0) {
            throw new RuntimeException(error);
        }
        return css;
    }

    private String getDirectoryHash(String directory) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String code = "";
        File[] list = new File(directory).listFiles();
        if (list == null) {
            return null;
        }
        for (File f : list) {
            code = f.isDirectory() ? code + f.getName() + f.length() + f.lastModified() + this.getDirectoryHash(f.getAbsolutePath()) : code + f.getName() + f.length() + f.lastModified();
        }
        return new String(MessageDigest.getInstance("MD5").digest(code.getBytes("UTF-8")));
    }
}

