/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import com.google.inject.Injector;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import java.util.ArrayList;
import java.util.List;
import org.javalite.activeweb.freemarker.FreeMarkerTag;

public abstract class AbstractFreeMarkerConfig {
    private Configuration configuration;
    private List<FreeMarkerTag> userTags = new ArrayList<FreeMarkerTag>();

    public void setConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void registerTag(String name, FreeMarkerTag tag) {
        this.configuration.setSharedVariable(name, (TemplateModel)tag);
        this.userTags.add(tag);
    }

    public FreeMarkerTag getTag(String tagName) {
        return (FreeMarkerTag)this.configuration.getSharedVariable(tagName);
    }

    public abstract void init();

    public void inject(Injector injector) {
        for (FreeMarkerTag tag : this.userTags) {
            injector.injectMembers((Object)tag);
        }
    }
}

