/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.template.SimpleHash;
import freemarker.template.TemplateBooleanModel;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.TagFactory;
import org.javalite.common.Util;

public class FormTag
extends FreeMarkerTag {
    @Override
    protected void render(Map params, String body, Writer writer) throws Exception {
        Boolean restful;
        String controllerPath;
        boolean putOrDelete;
        SimpleHash activeweb = (SimpleHash)this.get("activeweb");
        if (activeweb == null || !params.containsKey("controller") && !activeweb.toMap().containsKey("controller")) {
            throw new ViewException("could not render this form, controller is not found");
        }
        String bodyPrefix = "";
        boolean bl = putOrDelete = params.get("method") != null && (params.get("method").toString().equalsIgnoreCase("put") || params.get("method").toString().equalsIgnoreCase("delete"));
        if (putOrDelete) {
            String method = params.get("method").toString().toLowerCase();
            bodyPrefix = "\n\t<input type='hidden' name='_method' value='" + method + "' />";
        }
        if (Util.blank((Object)body)) {
            body = "&nbsp;";
        }
        TagFactory tf = new TagFactory("form", bodyPrefix + body);
        String contextPath = this.getContextPath();
        String action = params.get("action") == null ? null : params.get("action").toString();
        String string = controllerPath = params.get("controller") == null ? activeweb.get("controller").toString() : params.get("controller").toString();
        if (params.get("controller") == null) {
            restful = ((TemplateBooleanModel)activeweb.get("restful")).getAsBoolean();
        } else {
            AppController controllerInstance = (AppController)Class.forName(ControllerFactory.getControllerClassName(controllerPath)).newInstance();
            restful = controllerInstance.restful();
        }
        String id = params.get("id") == null ? null : params.get("id").toString();
        String formAction = Router.generate(controllerPath, action, id, restful, new HashMap());
        tf.attribute("action", contextPath + formAction);
        if (putOrDelete) {
            tf.attribute("method", "post");
        } else if (params.get("method") != null) {
            tf.attribute("method", params.get("method").toString());
        }
        if (params.get("html_id") != null) {
            tf.attribute("id", params.get("html_id").toString());
        }
        tf.addAttributesExcept(params, "controller", "action", "method", "id", "html_id", "data");
        if (params.containsKey("data")) {
            tf.textAttributes(params.get("data").toString());
        }
        tf.write(writer);
    }
}

