/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.utility.DeepUnwrap;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.javalite.activeweb.AppContext;
import org.javalite.activeweb.Cookie;
import org.javalite.activeweb.RequestUtils;
import org.javalite.activeweb.Route;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.freemarker.FreeMarkerTL;
import org.javalite.activeweb.freemarker.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FreeMarkerTag
implements TemplateDirectiveModel {
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());
    private String context;

    protected Logger logger() {
        return this.logger;
    }

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        FreeMarkerTL.setEnvironment(env);
        StringWriter sw = new StringWriter();
        if (body != null) {
            body.render((Writer)sw);
        }
        try {
            this.render(params, sw.toString(), env.getOut());
        }
        catch (ViewException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ViewException(e);
        }
    }

    protected TemplateModel get(Object name) {
        try {
            return FreeMarkerTL.getEnvironment().getVariable(name.toString());
        }
        catch (Exception e) {
            throw new ViewException(e);
        }
    }

    protected Object getUnwrapped(Object name) {
        try {
            return DeepUnwrap.unwrap((TemplateModel)this.get(name));
        }
        catch (TemplateException e) {
            throw new ViewException(e);
        }
    }

    protected <T> T getUnwrapped(Object name, Class<T> clazz) {
        return clazz.cast(this.getUnwrapped(name));
    }

    protected abstract void render(Map var1, String var2, Writer var3) throws Exception;

    protected void validateParamsPresence(Map params, String ... names) {
        Util.validateParamsPresence(params, names);
    }

    protected String getContextPath() {
        if (this.context != null) {
            return this.context;
        }
        if (this.get("context_path") == null) {
            throw new ViewException("context_path missing - red alarm!");
        }
        return this.get("context_path").toString();
    }

    protected void process(String text, Map params, Writer writer) {
        try {
            Template t = new Template("temp", (Reader)new StringReader(text), FreeMarkerTL.getEnvironment().getConfiguration());
            t.process((Object)params, writer);
        }
        catch (Exception e) {
            throw new ViewException(e);
        }
    }

    protected Map getAllVariables() {
        try {
            Iterator names = FreeMarkerTL.getEnvironment().getKnownVariableNames().iterator();
            HashMap vars = new HashMap();
            while (names.hasNext()) {
                Object name = names.next();
                vars.put(name, this.get(name.toString()));
            }
            return vars;
        }
        catch (Exception e) {
            throw new ViewException(e);
        }
    }

    public void overrideContext(String context) {
        this.context = context;
    }

    protected String param(String name) {
        return RequestUtils.param(name);
    }

    protected String getId() {
        return RequestUtils.getId();
    }

    protected String format() {
        return RequestUtils.format();
    }

    protected AppContext appContext() {
        return RequestUtils.appContext();
    }

    protected boolean isXhr() {
        return RequestUtils.isXhr();
    }

    protected String userAgent() {
        return RequestUtils.userAgent();
    }

    protected boolean xhr() {
        return RequestUtils.xhr();
    }

    protected Route getRoute() {
        return RequestUtils.getRoute();
    }

    protected boolean exists(String name) {
        return RequestUtils.exists(name);
    }

    protected boolean requestHas(String name) {
        return RequestUtils.requestHas(name);
    }

    protected String host() {
        return RequestUtils.host();
    }

    protected String ipAddress() {
        return RequestUtils.ipAddress();
    }

    protected String getRequestProtocol() {
        return RequestUtils.getRequestProtocol();
    }

    protected int getRequestPort() {
        String port = this.header("X-Forwarded-Port");
        return org.javalite.common.Util.blank((Object)port) ? this.port() : Integer.parseInt(port);
    }

    protected int port() {
        return RequestUtils.port();
    }

    protected String protocol() {
        return RequestUtils.protocol();
    }

    protected String getRequestHost() {
        return RequestUtils.getRequestHost();
    }

    protected String ipForwardedFor() {
        return RequestUtils.ipForwardedFor();
    }

    protected List<String> params(String name) {
        return RequestUtils.params(name);
    }

    protected Map<String, String> params1st() {
        return RequestUtils.params1st();
    }

    protected Map<String, String[]> params() {
        return RequestUtils.params();
    }

    protected Locale locale() {
        return RequestUtils.locale();
    }

    protected Locale getLocale() {
        return RequestUtils.getLocale();
    }

    protected Map session() {
        HashMap session;
        try {
            SimpleHash sessionHash = (SimpleHash)this.get("session");
            session = sessionHash.toMap();
        }
        catch (Exception e) {
            this.logger().warn("failed to get a session map in context, returning session without data!!!", (Throwable)e);
            session = new HashMap();
        }
        return Collections.unmodifiableMap(session);
    }

    private SimpleHash getSessionHash() {
        return (SimpleHash)this.get("session");
    }

    protected Object sessionObject(String name) {
        return this.session(name);
    }

    protected Object session(String name) {
        return this.session().get(name);
    }

    public List<Cookie> cookies() {
        return RequestUtils.cookies();
    }

    public Cookie cookie(String name) {
        return RequestUtils.cookie(name);
    }

    protected String cookieValue(String name) {
        return RequestUtils.cookieValue(name);
    }

    protected String path() {
        return RequestUtils.path();
    }

    protected String url() {
        return RequestUtils.url();
    }

    protected String queryString() {
        return RequestUtils.queryString();
    }

    protected String method() {
        return RequestUtils.method();
    }

    protected boolean isGet() {
        return RequestUtils.isGet();
    }

    protected boolean isPost() {
        return RequestUtils.isPost();
    }

    protected boolean isPut() {
        return RequestUtils.isPut();
    }

    protected boolean isDelete() {
        return RequestUtils.isDelete();
    }

    protected boolean isMethod(String method) {
        return RequestUtils.isMethod(method);
    }

    protected boolean isHead() {
        return this.isMethod("head");
    }

    protected String context() {
        return RequestUtils.context();
    }

    protected String uri() {
        return RequestUtils.uri();
    }

    protected String remoteHost() {
        return RequestUtils.remoteHost();
    }

    protected String remoteAddress() {
        return RequestUtils.remoteAddress();
    }

    protected String header(String name) {
        return RequestUtils.header(name);
    }

    protected Map<String, String> headers() {
        return RequestUtils.headers();
    }
}

