/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.javalite.activeweb.Configuration;
import org.javalite.activeweb.InitException;
import org.javalite.activeweb.TemplateManager;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.ViewMissingException;
import org.javalite.activeweb.freemarker.AbstractFreeMarkerConfig;
import org.javalite.activeweb.freemarker.ConfirmationTag;
import org.javalite.activeweb.freemarker.ContentForTag;
import org.javalite.activeweb.freemarker.ContentTL;
import org.javalite.activeweb.freemarker.DebugTag;
import org.javalite.activeweb.freemarker.FlashTag;
import org.javalite.activeweb.freemarker.FormTag;
import org.javalite.activeweb.freemarker.FreeMarkerTL;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.LinkToTag;
import org.javalite.activeweb.freemarker.MessageTag;
import org.javalite.activeweb.freemarker.RenderTag;
import org.javalite.activeweb.freemarker.SelectTag;
import org.javalite.activeweb.freemarker.WrapTag;
import org.javalite.activeweb.freemarker.YieldTag;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerTemplateManager
extends TemplateManager {
    private freemarker.template.Configuration config;
    private String defaultLayout;
    private String location;
    private Logger logger = LoggerFactory.getLogger((String)this.getClass().getSimpleName());

    public FreeMarkerTemplateManager() {
        this.config = new freemarker.template.Configuration();
        this.config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.config.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.config.setSharedVariable("link_to", (TemplateModel)new LinkToTag());
        this.config.setSharedVariable("form", (TemplateModel)new FormTag());
        this.config.setSharedVariable("content", (TemplateModel)new ContentForTag());
        this.config.setSharedVariable("yield", (TemplateModel)new YieldTag());
        this.config.setSharedVariable("flash", (TemplateModel)new FlashTag());
        this.config.setSharedVariable("render", (TemplateModel)new RenderTag());
        this.config.setSharedVariable("confirm", (TemplateModel)new ConfirmationTag());
        this.config.setSharedVariable("wrap", (TemplateModel)new WrapTag());
        this.config.setSharedVariable("debug", (TemplateModel)new DebugTag());
        this.config.setSharedVariable("select", (TemplateModel)new SelectTag());
        this.config.setSharedVariable("message", (TemplateModel)new MessageTag());
        AbstractFreeMarkerConfig freeMarkerConfig = Configuration.getFreeMarkerConfig();
        if (freeMarkerConfig != null) {
            freeMarkerConfig.setConfiguration(this.config);
            freeMarkerConfig.init();
        }
    }

    @Override
    public void merge(Map values, String template, Writer writer) {
        this.merge(values, template, this.defaultLayout, null, writer);
    }

    @Override
    public void merge(Map input, String template, String layout, String format, Writer writer) {
        try {
            Template pageTemplate;
            this.logger.info("rendering template: '" + template + "' with layout: '" + layout + "', session: " + this.sessionId());
            if (Configuration.getEnv().equals("development")) {
                this.config.clearTemplateCache();
            }
            ContentTL.reset();
            try {
                String templateName = Util.blank((Object)format) ? template + ".ftl" : template + "." + format + ".ftl";
                pageTemplate = this.config.getTemplate(templateName);
            }
            catch (FileNotFoundException e) {
                this.logger.warn("Current location: " + new File(".").getCanonicalPath());
                throw e;
            }
            if (layout == null) {
                pageTemplate.process((Object)input, writer);
            } else {
                StringWriter pageWriter = new StringWriter();
                pageTemplate.process((Object)input, (Writer)pageWriter);
                HashMap<String, String> values = new HashMap<String, String>(input);
                values.put("page_content", pageWriter.toString());
                Map<String, List<String>> assignedValues = ContentTL.getAllContent();
                for (String name : assignedValues.keySet()) {
                    values.put(name, Util.join((Collection)assignedValues.get(name), (String)" "));
                }
                Template layoutTemplate = this.config.getTemplate(layout + ".ftl");
                layoutTemplate.process(values, writer);
                FreeMarkerTL.setEnvironment(null);
            }
        }
        catch (FileNotFoundException e) {
            throw new ViewMissingException(this.errorMessage(layout, template), e);
        }
        catch (ViewException e) {
            this.logger.error(this.errorMessage(layout, template));
            throw e;
        }
        catch (Exception e) {
            throw new ViewException(this.errorMessage(layout, template), e);
        }
    }

    private String errorMessage(String layout, String template) {
        return "Failed to render template: '" + (this.location != null ? this.location : "") + template + ".ftl" + (layout == null ? "', without layout" : "', with layout: '" + (this.location != null ? this.location : "") + layout + "'");
    }

    @Override
    public void setServletContext(ServletContext ctx) {
        if (this.location == null) {
            this.config.setServletContextForTemplateLoading((Object)ctx, "WEB-INF/views/");
        }
    }

    public void setTemplateClassPath(String path) throws IOException {
        this.config.setClassForTemplateLoading(this.getClass(), path);
    }

    public void setDefaultLayout(String layoutPath) {
        this.defaultLayout = layoutPath;
    }

    @Override
    public void setTemplateLocation(String templateLocation) {
        this.location = templateLocation;
        try {
            this.config.setDirectoryForTemplateLoading(new File(templateLocation));
        }
        catch (Exception e) {
            throw new InitException(e);
        }
    }

    public void registerTag(String name, FreeMarkerTag tag) {
        this.config.setSharedVariable(name, (TemplateModel)tag);
    }

    public FreeMarkerTag getTag(String tagName) {
        return (FreeMarkerTag)this.config.getSharedVariable(tagName);
    }
}

