/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelIterator;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.javalite.activeweb.AppController;
import org.javalite.activeweb.ControllerFactory;
import org.javalite.activeweb.Router;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.TagFactory;
import org.javalite.common.Util;

public class LinkToTag
extends FreeMarkerTag {
    @Override
    protected void render(Map params, String body, Writer writer) throws Exception {
        Boolean restful;
        String controller;
        if (params.get("controller") != null) {
            controller = params.get("controller").toString();
            AppController controllerInstance = (AppController)Class.forName(ControllerFactory.getControllerClassName(controller)).newInstance();
            restful = controllerInstance.restful();
        } else if (this.get("activeweb") != null) {
            Map activeweb = (Map)this.getUnwrapped("activeweb");
            controller = activeweb.get("controller").toString();
            restful = (Boolean)activeweb.get("restful");
        } else {
            throw new IllegalArgumentException("link_to directive is missing: 'controller', and no controller found in context");
        }
        if (!controller.startsWith("/")) {
            controller = "/" + controller;
        }
        if (controller.contains(".")) {
            throw new IllegalArgumentException("'controller' attribute cannot have dots in value, use slashes: '/'");
        }
        if (Util.blank((Object)body)) {
            throw new IllegalArgumentException("must provide body text");
        }
        if (params.get("query_params") != null && params.get("query_string") != null) {
            throw new IllegalArgumentException("Cannot define query_params and query_string. Choose either one or another");
        }
        String action = params.containsKey("action") ? params.get("action").toString() : null;
        String id = Util.blank(params.get("id")) ? null : params.get("id").toString();
        Map queryParams = this.getQueryParams(params);
        String href = this.getContextPath();
        href = href + Router.generate(controller, action, id, restful, queryParams);
        href = href + (params.containsKey("query_string") ? "?" + params.get("query_string") : "");
        TagFactory tf = new TagFactory("a", body);
        tf.attribute("href", href);
        if (params.containsKey("destination") && params.get("destination") != null) {
            tf.attribute("data-destination", params.get("destination").toString());
        }
        if (params.containsKey("form") && params.get("form") != null) {
            tf.attribute("data-form", params.get("form").toString());
        }
        if (params.containsKey("method") && params.get("method") != null) {
            tf.attribute("data-method", params.get("method").toString());
        }
        if (params.containsKey("before") && params.get("before") != null) {
            tf.attribute("data-before", params.get("before").toString());
        }
        if (params.containsKey("before_arg") && params.get("before_arg") != null) {
            tf.attribute("data-before-arg", params.get("before_arg").toString());
        }
        if (params.containsKey("after_arg") && params.get("after_arg") != null) {
            tf.attribute("data-after-arg", params.get("after_arg").toString());
        }
        if (params.containsKey("after") && params.get("after") != null) {
            tf.attribute("data-after", params.get("after").toString());
        }
        if (params.containsKey("confirm") && params.get("confirm") != null) {
            tf.attribute("data-confirm", params.get("confirm").toString());
        }
        if (params.containsKey("error") && params.get("error") != null) {
            tf.attribute("data-error", params.get("error").toString());
        }
        if (params.containsKey("html_id")) {
            tf.attribute("id", params.get("html_id").toString());
        }
        tf.attribute("data-link", "aw");
        tf.addAttributesExcept(params, "controller", "action", "form", "id", "method", "query_string", "query_params", "context_path", "destination", "before", "before_arg", "after", "after_arg", "confirm", "error", "html_id", "data");
        if (params.containsKey("data")) {
            tf.textAttributes(params.get("data").toString());
        }
        writer.write(tf.toString());
    }

    private Map getQueryParams(Map params) throws TemplateModelException {
        TemplateHashModelEx modelEx = (TemplateHashModelEx)params.get("query_params");
        if (modelEx == null) {
            return new HashMap();
        }
        TemplateCollectionModel keys = modelEx.keys();
        TemplateModelIterator keysIt = keys.iterator();
        HashMap<String, String> queryParams = new HashMap<String, String>();
        while (keysIt.hasNext()) {
            TemplateModel key = keysIt.next();
            queryParams.put(key.toString(), modelEx.get(key.toString()).toString());
        }
        return queryParams;
    }
}

