/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.template.SimpleScalar;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.javalite.activeweb.Messages;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.common.Util;

public class MessageTag
extends FreeMarkerTag {
    @Override
    protected void render(Map params, String body, Writer writer) throws Exception {
        if (params.containsKey("key")) {
            String key = params.get("key").toString();
            if (params.containsKey("locale")) {
                Locale locale;
                String localeString = params.get("locale").toString();
                if (localeString.contains("_")) {
                    String language = Util.split((String)localeString, (char)'_')[0];
                    String country = Util.split((String)localeString, (char)'_')[1];
                    locale = new Locale(language, country);
                } else {
                    String language = localeString;
                    locale = new Locale(language);
                }
                writer.write(Messages.message(key, locale, (Object[])this.getParamsArray(params)));
            } else {
                writer.write(Messages.message(key, this.getParamsArray(params)));
            }
        } else {
            writer.write("<span style=\"display:none\">you failed to supply key for this message tag</span>");
        }
    }

    private String[] getParamsArray(Map params) {
        int index = 0;
        ArrayList<String> paramList = new ArrayList<String>();
        String paramName = "param";
        while (params.containsKey(paramName + index)) {
            String param = ((SimpleScalar)params.get(paramName + index)).getAsString();
            paramList.add(param);
            ++index;
        }
        return paramList.toArray(new String[0]);
    }
}

