/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.core.Environment;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleSequence;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.javalite.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenderTag
implements TemplateDirectiveModel {
    private static Logger LOGGER = LoggerFactory.getLogger((String)RenderTag.class.getSimpleName());

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        if (params.get("partial") == null) {
            throw new IllegalArgumentException("attribute 'partial' is missing");
        }
        String partialArgument = params.get("partial").toString();
        String partialPath = this.getTemplatePath(env.getTemplate().getName(), partialArgument);
        Template spacerTemplate = null;
        if (params.get("spacer") != null) {
            String spacerPath = this.getTemplatePath(env.getTemplate().getName(), params.get("spacer").toString());
            spacerTemplate = env.getConfiguration().getTemplate(spacerPath + ".ftl");
        }
        String[] partialParts = Util.split((String)params.get("partial").toString(), (char)'/');
        String partialName = partialParts[partialParts.length - 1];
        Template partialTemplate = env.getConfiguration().getTemplate(partialPath + ".ftl");
        LOGGER.debug("rendering: " + partialPath + ".ftl");
        if (!params.containsKey("collection")) {
            SimpleHash envValues = this.getHash(env);
            envValues.putAll(params);
            partialTemplate.process((Object)envValues, env.getOut());
        } else {
            if (params.get("collection") == null) {
                throw new IllegalArgumentException("collection must be provided!");
            }
            List collection = ((SimpleSequence)params.get("collection")).toList();
            for (int i = 0; i < collection.size(); ++i) {
                SimpleHash hash = this.getHash(env);
                hash.putAll(params);
                hash.put(partialName, collection.get(i));
                hash.put(partialName + "_counter", (Object)i);
                hash.put("first", i == 0);
                hash.put("last", i == collection.size() - 1);
                partialTemplate.process((Object)hash, env.getOut());
                if (i >= collection.size() - 1 || spacerTemplate == null) continue;
                spacerTemplate.process((Object)hash, env.getOut());
            }
        }
    }

    private String getTemplatePath(String containerName, String templateArgumentName) {
        String templatePath;
        if (!templateArgumentName.startsWith("/")) {
            String path = containerName.substring(0, containerName.lastIndexOf("/"));
            templatePath = "/" + path + "/_" + templateArgumentName;
        } else {
            if (Util.split((String)templateArgumentName, (char)'/').length < 2) {
                throw new IllegalArgumentException("wrong name of shared partial");
            }
            String path = templateArgumentName.substring(0, templateArgumentName.lastIndexOf("/"));
            templatePath = path + "/_" + templateArgumentName.substring(templateArgumentName.lastIndexOf("/") + 1);
        }
        return templatePath;
    }

    private SimpleHash getHash(Environment env) throws TemplateModelException {
        Set names = env.getKnownVariableNames();
        SimpleHash simpleHash = new SimpleHash();
        for (Object name : names) {
            simpleHash.put(name.toString(), (Object)env.getVariable(name.toString()));
        }
        return simpleHash;
    }
}

