/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import freemarker.template.SimpleSequence;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.javalite.activeweb.ViewException;
import org.javalite.activeweb.freemarker.FreeMarkerTag;
import org.javalite.activeweb.freemarker.SelectOption;
import org.javalite.activeweb.freemarker.TagFactory;

public class SelectTag
extends FreeMarkerTag {
    @Override
    protected void render(Map params, String body, Writer writer) throws Exception {
        this.validateParamsPresence(params, "list");
        Object listObj = params.get("list");
        if (!(listObj instanceof SimpleSequence)) {
            throw new ViewException("Mandatory parameter 'list' must be java.util.List");
        }
        SimpleSequence sequence = (SimpleSequence)listObj;
        List options = sequence.toList();
        for (Object item : options) {
            if (item instanceof SelectOption) continue;
            throw new ViewException("Must place " + SelectOption.class.getName() + " instances into select tag");
        }
        StringBuffer optionsBuffer = new StringBuffer();
        for (Object o : options) {
            SelectOption option = (SelectOption)o;
            TagFactory tf = new TagFactory("option", option.getLabel());
            tf.attribute("value", option.getValue());
            if (!option.isEnabled()) {
                tf.attribute("disabled", "true");
            }
            if (option.isSelected()) {
                tf.attribute("selected", "true");
            }
            optionsBuffer.append(tf.toString());
        }
        TagFactory selectTf = new TagFactory("select", body + optionsBuffer);
        selectTf.addAttributesExcept(params, "list", "data");
        if (params.containsKey("data")) {
            selectTf.textAttributes(params.get("data").toString());
        }
        selectTf.write(writer);
    }
}

