/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.activeweb.freemarker;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.javalite.common.Util;

public class TagFactory {
    private String name;
    private String body;
    private String textAttributes;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public TagFactory(String name, String body) {
        this.name = name;
        this.body = body;
    }

    public void textAttributes(String textAttributes) {
        this.textAttributes = textAttributes;
    }

    public void attribute(String name, String value) {
        this.attributes.add(new Attribute(name, value));
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        this.write(sw);
        return sw.toString();
    }

    public void write(Writer w) {
        try {
            w.write("<");
            w.write(this.name);
            for (Attribute a : this.attributes) {
                w.write(" ");
                w.write(a.name());
                w.write("=");
                w.write("\"");
                w.write(a.value());
                w.write("\"");
            }
            if (this.textAttributes != null) {
                w.write(" ");
                w.write(this.textAttributes);
            }
            if (Util.blank((Object)this.body)) {
                w.write("/>");
            } else {
                w.write(">");
                w.write(this.body);
                w.write("</");
                w.write(this.name);
                w.write(">");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addAttributesExcept(Map params, String ... exceptions) {
        List<String> exceptionList = Arrays.asList(exceptions);
        for (Object key : params.keySet()) {
            if (exceptionList.contains(key)) continue;
            this.attribute(key.toString(), params.get(key).toString());
        }
    }

    class Attribute {
        private String name;
        private String value;

        Attribute(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }
    }
}

