/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.javalite.db_migrator.DatabaseType;
import org.javalite.db_migrator.MigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbUtils {
    private static ThreadLocal<Connection> connectionTL = new ThreadLocal();
    private static Logger LOGGER = LoggerFactory.getLogger(DbUtils.class);
    private static final String POSTGRESQL_FRAGMENT = ":postgresql:";
    private static final String MYSQL_FRAGMENT = ":mysql:";
    private static final String HSQL_FRAGMENT = ":hsqldb:";
    private static final String H2_FRAGMENT = ":h2:";
    private static final String SQL_SERVER_JTDS_FRAGMENT = ":jtds:sqlserver:";
    private static final String SQL_SERVER_MS_2000_FRAGMENT = ":microsoft:sqlserver:";
    private static final String SQL_SERVER_MS_2005_FRAGMENT = ":sqlserver:";
    private static final String DB2_FRAGMENT = ":db2:";
    private static final String ORACLE_FRAGMENT = ":oracle:";
    private static final String CLICKHOUSE_FRAGMENT = ":clickhouse:";

    private DbUtils() {
    }

    public static String driverClass(String url) {
        assert (!DbUtils.blank(url));
        if (url.contains(POSTGRESQL_FRAGMENT)) {
            return "org.postgresql.Driver";
        }
        if (url.contains(MYSQL_FRAGMENT)) {
            return "com.mysql.jdbc.Driver";
        }
        if (url.contains(HSQL_FRAGMENT)) {
            return "org.hsqldb.jdbcDriver";
        }
        if (url.contains(H2_FRAGMENT)) {
            return "org.h2.Driver";
        }
        if (url.contains(SQL_SERVER_JTDS_FRAGMENT)) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (url.contains(SQL_SERVER_MS_2000_FRAGMENT)) {
            return "com.microsoft.jdbc.sqlserver.SQLServerDriver";
        }
        if (url.contains(SQL_SERVER_MS_2005_FRAGMENT)) {
            return "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        }
        if (url.contains(DB2_FRAGMENT)) {
            return "com.ibm.db2.jcc.DB2Driver";
        }
        if (url.contains(ORACLE_FRAGMENT)) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        return null;
    }

    public static DatabaseType databaseType(String url) {
        assert (!DbUtils.blank(url));
        if (url.contains(POSTGRESQL_FRAGMENT)) {
            return DatabaseType.POSTGRESQL;
        }
        if (url.contains(MYSQL_FRAGMENT)) {
            return DatabaseType.MYSQL;
        }
        if (url.contains(HSQL_FRAGMENT)) {
            return DatabaseType.HSQL;
        }
        if (url.contains(H2_FRAGMENT)) {
            return DatabaseType.H2;
        }
        if (url.contains(SQL_SERVER_JTDS_FRAGMENT)) {
            return DatabaseType.SQL_SERVER;
        }
        if (url.contains(SQL_SERVER_MS_2000_FRAGMENT)) {
            return DatabaseType.SQL_SERVER;
        }
        if (url.contains(SQL_SERVER_MS_2005_FRAGMENT)) {
            return DatabaseType.SQL_SERVER;
        }
        if (url.contains(DB2_FRAGMENT)) {
            return DatabaseType.DB2;
        }
        if (url.contains(ORACLE_FRAGMENT)) {
            return DatabaseType.ORACLE;
        }
        if (url.contains(CLICKHOUSE_FRAGMENT)) {
            return DatabaseType.CLICKHOUSE;
        }
        return DatabaseType.UNKNOWN;
    }

    public static String extractDatabaseName(String url) {
        int leftIndex = url.lastIndexOf("/");
        if (leftIndex == -1) {
            leftIndex = url.lastIndexOf(":");
        }
        ++leftIndex;
        int rightIndex = url.length();
        if (url.contains("?")) {
            rightIndex = url.indexOf("?");
        } else if (url.contains(";")) {
            rightIndex = url.indexOf(";");
        }
        return url.substring(leftIndex, rightIndex);
    }

    public static String extractServerUrl(String url) {
        int optionsIndex;
        int rightIndex = url.length();
        if (url.lastIndexOf("/") != -1) {
            rightIndex = url.lastIndexOf("/");
        } else if (url.lastIndexOf(":") != -1) {
            rightIndex = url.lastIndexOf(":");
        }
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(url.substring(0, rightIndex));
        if (DatabaseType.POSTGRESQL.equals((Object)DbUtils.databaseType(url))) {
            baseUrl.append("/postgres");
        }
        if ((optionsIndex = url.indexOf("?")) == -1) {
            optionsIndex = url.indexOf(";");
        }
        if (optionsIndex != -1) {
            baseUrl.append(url.substring(optionsIndex));
        }
        return baseUrl.toString();
    }

    public static Connection connection() {
        return connectionTL.get();
    }

    public static int exec(String statement) {
        Statement s = null;
        try {
            int count;
            s = DbUtils.connection().createStatement();
            LOGGER.info("Executing: " + statement);
            int n = count = s.executeUpdate(statement);
            return n;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            DbUtils.closeQuietly(s);
        }
    }

    public static void closeQuietly(Object toClose) {
        try {
            toClose.getClass().getMethod("close", new Class[0]).invoke(toClose, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void openConnection(String driver, String url, String username, String password) {
        try {
            Class.forName(driver);
            DbUtils.attach(DriverManager.getConnection(url, username, password));
        }
        catch (Exception e) {
            throw new MigrationException(e);
        }
    }

    public static void attach(Connection connection) {
        connectionTL.set(connection);
    }

    public static void detach() {
        connectionTL.set(null);
    }

    public static void closeConnection() {
        try {
            DbUtils.connection().close();
            DbUtils.detach();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean blank(String str) {
        if (str != null && str.length() > 0) {
            for (int i = 0; i < str.length(); ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static int countMigrations() {
        return DbUtils.countRows("schema_version");
    }

    public static int countRows(String table) {
        int n;
        ResultSet rs;
        Statement st;
        block5: {
            st = null;
            rs = null;
            st = DbUtils.connection().createStatement();
            rs = st.executeQuery("select count(*) from " + table);
            if (!rs.next()) break block5;
            int n2 = rs.getInt(1);
            DbUtils.closeQuietly(rs);
            DbUtils.closeQuietly(st);
            return n2;
        }
        try {
            n = 0;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(st);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(rs);
        DbUtils.closeQuietly(st);
        return n;
    }
}

