/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.javalite.common.Util;
import org.javalite.db_migrator.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration
implements Comparable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Migration.class);
    private static final String DEFAULT_DELIMITER = ";";
    private static final String DELIMITER_KEYWORD = "DELIMITER";
    private static final String[] COMMENT_CHARS = new String[]{"--", "#", "//"};
    private File migrationFile;
    private String version;

    public Migration(String version, File migrationFile) {
        this.migrationFile = migrationFile;
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.migrationFile.getName();
    }

    public void migrate(String encoding) throws Exception {
        List<String> lines = Files.readAllLines(Paths.get(this.migrationFile.getCanonicalPath(), new String[0]), encoding != null ? Charset.forName(encoding) : Charset.defaultCharset());
        String delimiter = DEFAULT_DELIMITER;
        ArrayList<String> statements = new ArrayList<String>();
        try {
            String currentStatement = "";
            for (String line : lines) {
                if (this.commentLine(line = line.trim()) || Util.blank((Object)line)) continue;
                if (line.startsWith(DELIMITER_KEYWORD)) {
                    delimiter = line.substring(10).trim();
                    continue;
                }
                if (line.endsWith(delimiter)) {
                    if (!Util.blank((Object)(currentStatement = currentStatement + line.substring(0, line.length() - delimiter.length())))) {
                        statements.add(currentStatement);
                    }
                    currentStatement = "";
                    continue;
                }
                currentStatement = currentStatement + line + System.getProperty("line.separator");
            }
            if (!Util.blank((Object)currentStatement)) {
                statements.add(currentStatement);
            }
            for (String statement : statements) {
                DbUtils.exec(statement);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error executing migration file: {}", (Object)this.migrationFile.getCanonicalPath(), (Object)e);
            throw e;
        }
    }

    private boolean commentLine(String line) {
        for (String cc : COMMENT_CHARS) {
            if (!line.trim().startsWith(cc)) continue;
            return true;
        }
        return false;
    }

    public int compareTo(Object o) {
        Migration other = (Migration)o;
        return this.getVersion().compareTo(other.getVersion());
    }
}

