/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.db_migrator.DatabaseType;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.MigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionStrategy {
    public static final String VERSION_TABLE = "schema_version";
    public static final String VERSION_COLUMN = "version";
    public static final String APPLIED_DATE_COLUMN = "applied_on";
    public static final String DURATION_COLUMN = "duration";
    private static final String DEFAULT_VALUE = "create table %s (%s varchar(32) not null unique, %s timestamp not null, %s int not null)";
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionStrategy.class);
    private static final Map<DatabaseType, String> CREATE_VERSION_TABLE_MAP = new HashMap<DatabaseType, String>();

    public void createSchemaVersionTable(DatabaseType dbType) {
        LOGGER.info("Creating schema version table for {} DB", (Object)dbType);
        String ddl = String.format(CREATE_VERSION_TABLE_MAP.getOrDefault((Object)dbType, DEFAULT_VALUE), VERSION_TABLE, VERSION_COLUMN, APPLIED_DATE_COLUMN, DURATION_COLUMN);
        DbUtils.exec(ddl);
    }

    public boolean versionTableExists() {
        try {
            DbUtils.countRows(VERSION_TABLE);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<String> getAppliedMigrations() {
        ArrayList<String> arrayList;
        Statement st = null;
        ResultSet rs = null;
        try {
            st = DbUtils.connection().createStatement();
            rs = st.executeQuery("select version from schema_version");
            ArrayList<String> migrations = new ArrayList<String>();
            while (rs.next()) {
                migrations.add(rs.getString(1));
            }
            arrayList = migrations;
        }
        catch (SQLException e) {
            try {
                throw new MigrationException(e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                DbUtils.closeQuietly(st);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(rs);
        DbUtils.closeQuietly(st);
        return arrayList;
    }

    public void recordMigration(String version, Date startTime, long duration) {
        PreparedStatement st = null;
        try {
            st = DbUtils.connection().prepareStatement("insert into schema_version values (?, ?, ?)");
            st.setString(1, version);
            st.setTimestamp(2, new Timestamp(startTime.getTime()));
            st.setLong(3, duration);
            st.execute();
        }
        catch (Exception e) {
            throw new MigrationException(e);
        }
        finally {
            DbUtils.closeQuietly(st);
        }
    }

    static {
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.HSQL, "create table %s (%s varchar not null, %s datetime not null, %s int not null, constraint %2$s_unique unique (%2$s))");
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.SQL_SERVER, "create table %s (%s varchar(32) not null unique, %s datetime not null, %s int not null)");
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.CLICKHOUSE, "create table %s (%s String, %s DateTime, %s Int32) engine = Log");
    }
}

