/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.maven.AbstractMigrationMojo;

public abstract class AbstractDbMigrationMojo
extends AbstractMigrationMojo {
    private String basedir;
    private String url;
    private String driver;
    private String username;
    private String password;
    private String environments;
    private String configFile;

    public final void execute() throws MojoExecutionException {
        block6: {
            FileInputStream is;
            Properties properties;
            block8: {
                File file;
                block7: {
                    block5: {
                        if (!DbUtils.blank(this.environments)) break block5;
                        this.executeCurrentConfiguration();
                        break block6;
                    }
                    file = DbUtils.blank(this.configFile) ? new File(this.basedir, "database.properties") : new File(this.configFile);
                    this.getLog().info((CharSequence)("Sourcing database configuration from file: " + file));
                    properties = new Properties();
                    if (!file.exists()) break block7;
                    is = null;
                    try {
                        is = new FileInputStream(file);
                        properties.load(is);
                    }
                    catch (IOException e) {
                        try {
                            throw new MojoExecutionException("Error reading " + file + " file", (Exception)e);
                        }
                        catch (Throwable throwable) {
                            DbUtils.closeQuietly(is);
                            throw throwable;
                        }
                    }
                    break block8;
                }
                throw new MojoExecutionException("File " + file + " not found");
            }
            DbUtils.closeQuietly(is);
            for (String environment : this.environments.split("\\s*,\\s*")) {
                this.getLog().info((CharSequence)("Environment: " + environment));
                this.url = properties.getProperty(environment + ".url");
                this.driver = properties.getProperty(environment + ".driver");
                this.username = properties.getProperty(environment + ".username");
                this.password = properties.getProperty(environment + ".password");
                this.executeCurrentConfiguration();
            }
        }
    }

    private void executeCurrentConfiguration() throws MojoExecutionException {
        if (DbUtils.blank(this.password)) {
            this.password = "";
        }
        if (DbUtils.blank(this.driver) && !DbUtils.blank(this.url)) {
            this.driver = DbUtils.driverClass(this.url);
        }
        this.validateConfiguration();
        this.executeMojo();
    }

    private void validateConfiguration() throws MojoExecutionException {
        if (DbUtils.blank(this.driver)) {
            throw new MojoExecutionException("No database driver. Specify one in the plugin configuration.");
        }
        if (DbUtils.blank(this.url)) {
            throw new MojoExecutionException("No database url. Specify one in the plugin configuration.");
        }
        if (DbUtils.blank(this.username)) {
            throw new MojoExecutionException("No database username. Specify one in the plugin configuration.");
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Can't load driver class " + this.driver + ". Be sure to include it as a plugin dependency.");
        }
    }

    public abstract void executeMojo() throws MojoExecutionException;

    public String getUrl() {
        return this.url;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getEnvironments() {
        return this.environments;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setEnvironments(String environments) {
        this.environments = environments;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    protected void openConnection() {
        this.openConnection(false);
    }

    protected void openConnection(boolean root) {
        String url = root ? DbUtils.extractServerUrl(this.getUrl()) : this.getUrl();
        DbUtils.openConnection(this.getDriver(), url, this.getUsername(), this.getPassword());
    }
}

