/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator.maven;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.maven.AbstractMigrationMojo;

public class NewMojo
extends AbstractMigrationMojo {
    public void execute() throws MojoExecutionException {
        if (DbUtils.blank(System.getProperty("name"))) {
            this.getLog().error((CharSequence)"Must provide name for migration: -Dname=migration_name");
            return;
        }
        String directory = this.getMigrationsPath();
        this.createMigrationsDirectory(directory);
        File file = new File(directory, this.createFileName());
        try {
            file.createNewFile();
            this.getLog().info((CharSequence)("Created new migration: " + file));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create migration file: " + file, (Exception)e);
        }
    }

    private String createFileName() {
        StringBuilder fileName = new StringBuilder();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        fileName.append(df.format(new Date()));
        String name = System.getProperty("name");
        if (!DbUtils.blank(name)) {
            fileName.append('_').append(name);
        }
        fileName.append(".sql");
        return fileName.toString();
    }

    private void createMigrationsDirectory(String directory) throws MojoExecutionException {
        File f = new File(directory);
        if (f.exists() && f.isFile()) {
            throw new MojoExecutionException("Provided path is not a directory: " + directory);
        }
        if (!f.exists() && f.mkdirs()) {
            this.getLog().info((CharSequence)("Creating new migration directory: " + directory));
        }
    }
}

