/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.javalite.db_migrator.GroovyMigration;
import org.javalite.db_migrator.Migration;
import org.javalite.db_migrator.MigrationException;
import org.javalite.db_migrator.SQLMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrationResolver.class);
    private String migrationsLocation;
    private static Pattern MIGRATION_FILE_PATTERN = Pattern.compile("^(\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d\\d)_.*\\.(sql|groovy)");

    public MigrationResolver(String migrationsLocation) {
        this.migrationsLocation = migrationsLocation;
    }

    public List<Migration> resolve() {
        File location = new File(this.migrationsLocation);
        LOGGER.info("Trying migrations at: {} ", (Object)location.getAbsolutePath());
        File[] files = location.listFiles();
        if (files == null || files.length == 0) {
            throw new MigrationException("No migrations are found at: " + location.getAbsolutePath());
        }
        ArrayList<File> migrationsFiles = new ArrayList<File>();
        for (File file : files) {
            if (file.isDirectory() || !MIGRATION_FILE_PATTERN.matcher(file.getName()).matches()) continue;
            migrationsFiles.add(file);
        }
        this.checkDuplicateVersions(migrationsFiles);
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        for (File migrationFile : migrationsFiles) {
            String version = this.extractVersion(migrationFile.getName());
            if (migrationFile.getName().endsWith("sql")) {
                migrations.add(new SQLMigration(version, migrationFile));
                continue;
            }
            if (migrationFile.getName().endsWith("groovy")) {
                migrations.add(new GroovyMigration(version, migrationFile));
                continue;
            }
            throw new RuntimeException("file type not supported");
        }
        Collections.sort(migrations);
        return migrations;
    }

    private List<String> extractVersions(List<File> migrationsFiles) {
        ArrayList<String> versions = new ArrayList<String>();
        for (File file : migrationsFiles) {
            versions.add(this.extractVersion(file.getName()));
        }
        return versions;
    }

    public void checkDuplicateVersions(List<File> files) {
        List<String> versions = this.extractVersions(files);
        HashSet<String> versionsHash = new HashSet<String>();
        for (String version : versions) {
            boolean isNew = versionsHash.add(version);
            if (isNew) continue;
            throw new MigrationException("Duplicate version discovered: " + version);
        }
    }

    public String extractVersion(String name) {
        String errorMessage = "Error parsing migration version from " + name;
        try {
            Matcher matcher = MIGRATION_FILE_PATTERN.matcher(name);
            boolean found = matcher.find();
            if (!found) {
                throw new MigrationException(errorMessage);
            }
            return matcher.group(1);
        }
        catch (MigrationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MigrationException(errorMessage, e);
        }
    }
}

