/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator;

import java.sql.Timestamp;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javalite.activejdbc.Base;
import org.javalite.common.Convert;
import org.javalite.db_migrator.DatabaseType;
import org.javalite.db_migrator.DbUtils;
import org.javalite.db_migrator.MigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VersionStrategy {
    private static final String DEFAULT_VALUE = "create table %s (%s varchar(32) not null unique, %s timestamp not null, %s int not null)";
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionStrategy.class);
    private static final Map<DatabaseType, String> CREATE_VERSION_TABLE_MAP = new HashMap<DatabaseType, String>();
    private String databaseName;
    private DatabaseType databaseType;

    VersionStrategy(String databaseName, DatabaseType databaseType) {
        this.databaseName = databaseName;
        this.databaseType = databaseType;
    }

    void createSchemaVersionTable(DatabaseType dbType) {
        LOGGER.info("Creating schema version table for {} DB", (Object)dbType);
        DbUtils.exec(String.format(CREATE_VERSION_TABLE_MAP.getOrDefault((Object)dbType, DEFAULT_VALUE), this.getTableName(), "version", "applied_on", "duration"), new Object[0]);
    }

    private String getTableName() {
        return this.databaseType.equals((Object)DatabaseType.CASSANDRA) ? this.databaseName + ".schema_version" : "schema_version";
    }

    boolean versionTableExists() {
        if (this.databaseType.equals((Object)DatabaseType.CASSANDRA)) {
            return false;
        }
        try {
            DbUtils.countMigrations(this.getTableName());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    List<String> getAppliedMigrations() {
        return Base.firstColumn((String)("select version from " + this.getTableName()), (Object[])new Object[0]);
    }

    void recordMigration(String version, Date startTime, long duration) {
        if (this.databaseType.equals((Object)DatabaseType.CASSANDRA)) {
            String useKeyspace = "USE " + this.databaseName;
            LOGGER.info("Executing: " + useKeyspace);
            DbUtils.exec(useKeyspace, new Object[0]);
        }
        try {
            Comparable<Instant> now = this.databaseType.equals((Object)DatabaseType.CASSANDRA) ? Instant.now() : new Timestamp(startTime.getTime());
            DbUtils.exec("insert into " + this.getTableName() + " (version, applied_on, duration) values (?, ?, ?)", version, now, Convert.toInteger((Object)duration));
        }
        catch (Exception e) {
            throw new MigrationException(e);
        }
    }

    static {
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.HSQL, "create table %s (%s varchar not null, %s datetime not null, %s int not null, constraint %2$s_unique unique (%2$s))");
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.SQL_SERVER, "create table %s (%s varchar(32) not null unique, %s datetime not null, %s int not null)");
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.CLICKHOUSE, "create table %s (%s String, %s DateTime, %s Int32) engine = Log");
        CREATE_VERSION_TABLE_MAP.put(DatabaseType.CASSANDRA, "CREATE TABLE IF NOT EXISTS %s (%s VARCHAR, %s TIMESTAMP, %s INT , PRIMARY KEY (version))");
    }
}

