/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.db_migrator.maven;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.javalite.activejdbc.Base;
import org.javalite.db_migrator.Migration;
import org.javalite.db_migrator.MigrationManager;
import org.javalite.db_migrator.maven.AbstractDbMigrationMojo;

public class ValidateMojo
extends AbstractDbMigrationMojo {
    @Override
    public void executeMojo() throws MojoExecutionException {
        this.getLog().info((CharSequence)("Validating " + this.getUrl() + " using migrations from " + this.getMigrationsPath()));
        try {
            this.openConnection();
            MigrationManager manager = new MigrationManager(this.getMigrationsPath(), this.getUrl());
            List<Migration> pendingMigrations = manager.getPendingMigrations();
            this.getLog().info((CharSequence)("Database: " + this.getUrl()));
            this.getLog().info((CharSequence)("Up-to-date: " + pendingMigrations.isEmpty()));
            if (!pendingMigrations.isEmpty()) {
                this.getLog().info((CharSequence)"Pending Migrations: ");
                for (Migration migration : pendingMigrations) {
                    this.getLog().info((CharSequence)migration.getName());
                }
            } else {
                this.getLog().info((CharSequence)"No pending migrations found");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to validate " + this.getUrl(), e);
        }
        finally {
            Base.close();
        }
    }
}

