/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.http;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.javalite.http.Http;
import org.javalite.http.HttpException;
import org.javalite.http.Request;

public class Post
extends Request<Post> {
    private final byte[] content;
    private Map<String, String> params = new HashMap<String, String>();

    public Post(String url, byte[] content, int connectTimeout, int readTimeout) {
        super(url, connectTimeout, readTimeout);
        this.content = content;
    }

    @Override
    public Post doConnect() {
        try {
            this.connection.setDoInput(true);
            this.connection.setDoOutput(true);
            this.connection.setUseCaches(false);
            this.connection.setRequestMethod("POST");
            this.connection.setInstanceFollowRedirects(this.redirect);
            if (this.params.size() > 0) {
                this.connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            OutputStream out = this.connection.getOutputStream();
            if (this.params.size() > 0) {
                out.write(Http.map2Content(this.params).getBytes());
            }
            if (this.content != null) {
                out.write(this.content);
            }
            out.flush();
            return this;
        }
        catch (Exception e) {
            throw new HttpException("Failed URL: " + this.url, e);
        }
    }

    public Post params(String ... namesAndValues) {
        if (namesAndValues == null) {
            throw new NullPointerException("'names and values' cannot be null");
        }
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("mus pas even number of arguments");
        }
        for (int i = 0; i < namesAndValues.length - 1; i += 2) {
            if (namesAndValues[i] == null) {
                throw new IllegalArgumentException("parameter names cannot be nulls");
            }
            this.params.put(namesAndValues[i], namesAndValues[i + 1]);
        }
        return this;
    }

    public Post param(String name, String value) {
        this.params.put(name, value);
        return this;
    }

    public static void main(String[] args) {
        Post post = Http.post("http://localhost:8080/hello").param("name", "John");
        System.out.println(post.text());
    }
}

