/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;

public class JsonHelper {
    private static final ObjectMapper mapper;
    private static final Map<Character, String> REPLACEMENT_CHARS;
    private static final Map<Character, String> CLEAN_CHARS;

    private JsonHelper() {
    }

    public static Map toMap(String json) {
        try {
            return (Map)mapper.readValue(json, Map.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map[] toMaps(String json) {
        try {
            return (Map[])mapper.readValue(json, Map[].class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonString(Object val) {
        try {
            return mapper.writeValueAsString(val);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJsonObject(Object ... namesAndValues) {
        if (namesAndValues.length % 2 != 0) {
            throw new IllegalArgumentException("number or arguments must be even");
        }
        StringBuilder sb = new StringBuilder("{");
        int count = 0;
        while (true) {
            Object name = namesAndValues[count];
            sb.append("\"").append(name).append("\":");
            if (!(namesAndValues[count + 1] instanceof Number)) {
                if (namesAndValues[count + 1] == null) {
                    sb.append("null");
                } else {
                    sb.append("\"").append(namesAndValues[count + 1].toString()).append("\"");
                }
            } else {
                sb.append(namesAndValues[count + 1].toString());
            }
            if (count >= namesAndValues.length - 2) break;
            sb.append(",");
            count += 2;
        }
        sb.append("}");
        return sb.toString();
    }

    public static List toList(String json) {
        try {
            return (List)mapper.readValue(json, List.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String cleanControlChars(String value) {
        return JsonHelper.sanitize(value, true);
    }

    public static String escapeControlChars(String value) {
        return JsonHelper.sanitize(value, false);
    }

    public static String sanitize(String value) {
        return JsonHelper.sanitize(value, false);
    }

    public static String sanitize(String value, boolean clean) {
        return JsonHelper.sanitize(value, clean, null);
    }

    public static String sanitize(String value, boolean clean, Character ... toEscape) {
        StringBuilder builder = new StringBuilder();
        Map<Character, String> replacements = clean ? CLEAN_CHARS : REPLACEMENT_CHARS;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (toEscape == null) {
                if (replacements.containsKey(Character.valueOf(c))) {
                    builder.append(replacements.get(Character.valueOf(c)));
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (replacements.containsKey(Character.valueOf(c)) && JsonHelper.contains(toEscape, c)) {
                builder.append(replacements.get(Character.valueOf(c)));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean contains(Character[] toEscape, char c) {
        Character[] characterArray = toEscape;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char escapeChar = characterArray[i].charValue();
            if (escapeChar != c) continue;
            return true;
        }
        return false;
    }

    static {
        int i;
        mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.WRITE_DATES_AS_TIMESTAMPS, false);
        REPLACEMENT_CHARS = new HashMap<Character, String>();
        CLEAN_CHARS = new HashMap<Character, String>();
        for (i = 0; i <= 31; ++i) {
            REPLACEMENT_CHARS.put(Character.valueOf((char)i), String.format("\\u%04x", i));
        }
        REPLACEMENT_CHARS.put(Character.valueOf('\u2028'), "\\u2028");
        REPLACEMENT_CHARS.put(Character.valueOf('\u2029'), "\\u2029");
        REPLACEMENT_CHARS.put(Character.valueOf('\"'), "\\\"");
        REPLACEMENT_CHARS.put(Character.valueOf('\\'), "\\\\");
        REPLACEMENT_CHARS.put(Character.valueOf('\t'), "\\t");
        REPLACEMENT_CHARS.put(Character.valueOf('\b'), "\\b");
        REPLACEMENT_CHARS.put(Character.valueOf('\n'), "\\n");
        REPLACEMENT_CHARS.put(Character.valueOf('\r'), "\\r");
        REPLACEMENT_CHARS.put(Character.valueOf('\f'), "\\f");
        for (i = 0; i <= 31; ++i) {
            CLEAN_CHARS.put(Character.valueOf((char)i), String.format("\\u%04x", i));
        }
        CLEAN_CHARS.put(Character.valueOf('\u2028'), "");
        CLEAN_CHARS.put(Character.valueOf('\u2029'), "");
        CLEAN_CHARS.put(Character.valueOf('\\'), "");
        CLEAN_CHARS.put(Character.valueOf('\t'), "");
        CLEAN_CHARS.put(Character.valueOf('\b'), "");
        CLEAN_CHARS.put(Character.valueOf('\n'), "");
        CLEAN_CHARS.put(Character.valueOf('\r'), "");
        CLEAN_CHARS.put(Character.valueOf('\f'), "");
    }
}

