/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.logging;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Layout;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.javalite.common.JsonHelper;
import org.javalite.common.Util;
import org.javalite.logging.Context;

public class JsonLog4jLayout
extends Layout {
    private SimpleDateFormat simpleDateFormat;

    public void setDateFormatPattern(String dateFormatPattern) {
        try {
            this.simpleDateFormat = new SimpleDateFormat(dateFormatPattern);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Incorrect date pattern. Ensure to use formats provided in https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html", e);
        }
    }

    public String format(LoggingEvent loggingEvent) {
        String loggerName = loggingEvent.getLoggerName();
        String level = loggingEvent.getLevel().toString();
        String message = loggingEvent.getMessage().toString().trim();
        if (!message.startsWith("{") && !message.startsWith("[")) {
            message = "\"" + message + "\"";
        }
        String threadName = loggingEvent.getThreadName();
        Date timeStamp = new Date(loggingEvent.getTimeStamp());
        String context = Context.toJSON();
        ThrowableInformation throwableInformation = loggingEvent.getThrowableInformation();
        String exception = "";
        if (throwableInformation != null) {
            exception = ",\"exception\":{\"message\":\"";
            Throwable throwable = throwableInformation.getThrowable();
            String exceptionMessage = throwable.getMessage() != null ? throwable.getMessage() : "";
            exception = exception + JsonHelper.sanitize(exceptionMessage, false, Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r')) + "\",\"stacktrace\":\"" + JsonHelper.escapeControlChars(Util.getStackTraceString(throwable)) + "\"}";
        }
        String contextJson = context != null ? ",\"context\":" + context : "";
        String timestampString = this.simpleDateFormat == null ? timeStamp.toString() : this.simpleDateFormat.format(timeStamp);
        return "{\"level\":\"" + level + "\",\"timestamp\":\"" + timestampString + "\",\"thread\":\"" + threadName + "\",\"logger\":\"" + loggerName + "\",\"message\":" + message + contextJson + exception + "}" + System.getProperty("line.separator");
    }

    public boolean ignoresThrowable() {
        return false;
    }

    public void activateOptions() {
    }
}

