/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.javalite.common.ConversionException;
import org.javalite.common.Util;

public final class Convert {
    private static final ThreadLocal<Calendar> THREADLOCAL_CAL_UTC = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
    };
    private static final ThreadLocal<Calendar> THREADLOCAL_CAL_DEFAULT = new ThreadLocal<Calendar>(){

        @Override
        protected Calendar initialValue() {
            return Calendar.getInstance();
        }
    };

    private Convert() {
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Clob) {
            return Convert.clobToString((Clob)value);
        }
        return value.toString();
    }

    private static String clobToString(Clob clob) {
        String string;
        Reader r = null;
        StringWriter sw = null;
        try {
            r = clob.getCharacterStream();
            sw = new StringWriter();
            Convert.copyStream(r, sw);
            string = sw.toString();
        }
        catch (Exception e) {
            try {
                throw new ConversionException(e);
            }
            catch (Throwable throwable) {
                Util.closeQuietly(sw);
                Util.closeQuietly((AutoCloseable)r);
                throw throwable;
            }
        }
        Util.closeQuietly((AutoCloseable)sw);
        Util.closeQuietly((AutoCloseable)r);
        return string;
    }

    private static void copyStream(Reader r, Writer w) throws IOException {
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = r.read(buffer))) {
            w.write(buffer, 0, n);
        }
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof BigDecimal) {
            return value.equals(BigDecimal.ONE);
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        if (value instanceof Character) {
            char c = ((Character)value).charValue();
            return c == 't' || c == 'T' || c == 'y' || c == 'Y' || c == '1';
        }
        String str = value.toString();
        return str.equalsIgnoreCase("true") || str.equalsIgnoreCase("t") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("y") || str.equals("1") || Boolean.parseBoolean(str);
    }

    public static Date toSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        try {
            return Date.valueOf(value.toString().trim());
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("failed to convert: '" + value + "' to java.sql.Date", e);
        }
    }

    public static Date truncateToSqlDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return Convert.truncateToSqlDate(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            return Convert.truncateToSqlDate(((Number)value).longValue());
        }
        try {
            return Date.valueOf(value.toString().trim());
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException("failed to convert: '" + value + "' to java.sql.Date", e);
        }
    }

    public static Date truncateToSqlDate(long time) {
        Calendar calendar = THREADLOCAL_CAL_DEFAULT.get();
        calendar.setTimeInMillis(time);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return new Date(calendar.getTimeInMillis());
    }

    public static String toIsoString(java.util.Date date) {
        if (date == null) {
            return null;
        }
        if (date instanceof Date) {
            return date.toString();
        }
        Calendar cal = THREADLOCAL_CAL_UTC.get();
        cal.setTime(date);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        char[] buf = new char[]{Character.forDigit(year / 1000, 10), Character.forDigit(year / 100 % 10, 10), Character.forDigit(year / 10 % 10, 10), Character.forDigit(year % 10, 10), '-', Character.forDigit(month / 10, 10), Character.forDigit(month % 10, 10), '-', Character.forDigit(day / 10, 10), Character.forDigit(day % 10, 10), 'T', Character.forDigit(hour / 10, 10), Character.forDigit(hour % 10, 10), ':', Character.forDigit(minute / 10, 10), Character.forDigit(minute % 10, 10), ':', Character.forDigit(second / 10, 10), Character.forDigit(second % 10, 10), 'Z'};
        return new String(buf);
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        try {
            return Double.valueOf(value.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Double", e);
        }
    }

    public static Time toTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof java.util.Date) {
            return new Time(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            return new Time(((Number)value).longValue());
        }
        return Time.valueOf(value.toString().trim());
    }

    public static Timestamp toTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        return Timestamp.valueOf(value.toString().trim());
    }

    public static Float toFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return Float.valueOf(value.toString().trim());
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).getTime();
        }
        try {
            return Long.valueOf(value.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Long", e);
        }
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.valueOf(value.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Integer", e);
        }
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        try {
            return new BigDecimal(value.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConversionException("failed to convert: '" + value + "' to BigDecimal", e);
        }
    }

    public static byte[] toBytes(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof Blob) {
            return Convert.toBytes((Blob)value);
        }
        return Convert.toString(value).getBytes();
    }

    public static byte[] toBytes(Blob blob) {
        InputStream is = null;
        try {
            is = blob.getBinaryStream();
            byte[] byArray = Util.bytes(is);
            return byArray;
        }
        catch (Exception e) {
            throw new ConversionException(e);
        }
        finally {
            Util.closeQuietly((AutoCloseable)is);
        }
    }

    public static Short toShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        try {
            return Short.valueOf(value.toString().trim());
        }
        catch (NumberFormatException e) {
            throw new ConversionException("failed to convert: '" + value + "' to Short", e);
        }
    }
}

