/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.common;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.List;
import org.javalite.common.Util;

public class RuntimeUtil {
    private static int MAX_BUFFER_SIZE = 2048;

    public static Response execute(int maxBuffer, String ... command) {
        return RuntimeUtil.execute(maxBuffer, null, command);
    }

    public static Response execute(int maxBuffer, File dir, List<String> envVars, String ... command) {
        if (dir != null && dir.isFile()) {
            throw new IllegalArgumentException("Location must be a directory, not a file ");
        }
        if (command.length == 0) {
            throw new IllegalArgumentException("Command must be provided.");
        }
        String[] commandAndArgs = command.length == 1 && command[0].contains(" ") ? Util.split(command[0], " ") : command;
        try {
            String[] localEnv = envVars == null ? null : envVars.toArray(new String[envVars.size()]);
            Process process = Runtime.getRuntime().exec(commandAndArgs, localEnv, dir);
            OutputReader stdOutReader = new OutputReader(process.getInputStream(), maxBuffer);
            OutputReader stdErrReader = new OutputReader(process.getErrorStream(), maxBuffer);
            Thread t1 = new Thread(stdOutReader);
            t1.start();
            Thread t2 = new Thread(stdErrReader);
            t2.start();
            int code = process.waitFor();
            t1.join();
            t2.join();
            String out = stdOutReader.getOutput();
            String err = stdErrReader.getOutput();
            return new Response(out, err, code);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Response execute(int maxBuffer, File dir, String ... command) {
        return RuntimeUtil.execute(maxBuffer, dir, null, command);
    }

    public static Response execute(String ... command) {
        return RuntimeUtil.execute(MAX_BUFFER_SIZE, command);
    }

    public static Response execute(String command) {
        return RuntimeUtil.execute(Util.split(command, " "));
    }

    static class OutputReader
    implements Runnable {
        private int maxBuffer;
        private InputStream is;
        private LinkedList<Character> buffer = new LinkedList();

        OutputReader(InputStream is, int maxBuffer) {
            this.is = is;
            this.maxBuffer = maxBuffer;
        }

        @Override
        public void run() {
            try {
                int s;
                InputStreamReader reader = new InputStreamReader(this.is);
                while ((s = reader.read()) != -1) {
                    if (this.buffer.size() == this.maxBuffer) {
                        this.buffer.remove(0);
                    }
                    this.buffer.add(Character.valueOf((char)s));
                }
                this.is.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public String getOutput() {
            StringBuilder stringBuilder = new StringBuilder(this.buffer.size());
            for (Character character : this.buffer) {
                stringBuilder.append(character);
            }
            return stringBuilder.toString();
        }
    }

    public static class Response {
        public final String out;
        public final String err;
        public final int exitValue;

        Response(String out, String err, int exitValue) {
            this.out = out;
            this.err = err;
            this.exitValue = exitValue;
        }
    }
}

