/*
 * Decompiled with CFR 0.152.
 */
package org.javalite.logging;

import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.javalite.common.JsonHelper;
import org.javalite.common.Util;
import org.javalite.logging.Context;

@Plugin(name="JsonLog4j2Layout", category="Core", elementType="layout", printObject=true)
public class JsonLog4j2Layout
extends AbstractStringLayout {
    private SimpleDateFormat simpleDateFormat;

    protected JsonLog4j2Layout() {
        super(Charset.defaultCharset());
    }

    protected JsonLog4j2Layout(Charset charset, String dateFormat) {
        super(charset);
        try {
            this.simpleDateFormat = new SimpleDateFormat(dateFormat);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Incorrect date pattern. Ensure to use formats provided in https://docs.oracle.com/javase/8/docs/api/java/text/SimpleDateFormat.html", e);
        }
    }

    public String toSerializable(LogEvent event) {
        String loggerName = event.getLoggerName();
        String level = event.getLevel().toString();
        String message = event.getMessage().getFormattedMessage();
        if (!message.startsWith("{") && !message.startsWith("[")) {
            message = "\"" + message + "\"";
        }
        String threadName = event.getThreadName();
        Date timeStamp = new Date(event.getTimeMillis());
        String context = Context.toJSON();
        Throwable throwable = event.getThrown();
        String exception = "";
        if (throwable != null) {
            exception = ",\"exception\":{\"message\":\"";
            String exceptionMessage = throwable.getMessage() != null ? throwable.getMessage() : "";
            exception = exception + JsonHelper.sanitize(exceptionMessage, false, Character.valueOf('\n'), Character.valueOf('\t'), Character.valueOf('\r')) + "\",\"stacktrace\":\"" + JsonHelper.escapeControlChars(Util.getStackTraceString(throwable)) + "\"}";
        }
        String contextJson = context != null ? ",\"context\":" + context : "";
        String timestampString = this.simpleDateFormat == null ? timeStamp.toString() : this.simpleDateFormat.format(timeStamp);
        return "{\"level\":\"" + level + "\",\"timestamp\":\"" + timestampString + "\",\"thread\":\"" + threadName + "\",\"logger\":\"" + loggerName + "\",\"message\":" + message + contextJson + exception + "}" + System.getProperty("line.separator");
    }

    @PluginFactory
    public static JsonLog4j2Layout createLayout(@PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="dateFormat", defaultString="yyyy-MM-dd HH:mm:ss.SSS") String dateFormat) {
        return new JsonLog4j2Layout(charset, dateFormat);
    }
}

