/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.math.MathContext;
import java.math.RoundingMode;
import javax.money.Monetary;
import javax.money.MonetaryContext;
import javax.money.MonetaryOperator;
import javax.money.RoundingQuery;
import javax.money.RoundingQueryBuilder;

enum RoundedMoneyMonetaryOperatorFactory {
    INSTANCE;

    private static final int SCALE_DEFAULT = 2;
    public static final String SCALE_KEY = "scale";

    MonetaryOperator getDefaultMonetaryOperator(MonetaryOperator rounding, MonetaryContext context) {
        if (rounding != null) {
            return rounding;
        }
        if (context != null) {
            return this.createUsingMonetaryContext(context);
        }
        return Monetary.getDefaultRounding();
    }

    private MonetaryOperator createUsingMonetaryContext(MonetaryContext context) {
        MathContext mathContext = (MathContext)context.get(MathContext.class);
        int scale = 2;
        if (context.getInt(SCALE_KEY) != null) {
            scale = context.getInt(SCALE_KEY);
        }
        if (mathContext != null) {
            return Monetary.getRounding((RoundingQuery)((RoundingQueryBuilder)RoundingQueryBuilder.of().set((Object)mathContext)).setScale(scale).build());
        }
        RoundingMode roundingMode = (RoundingMode)((Object)context.get(RoundingMode.class));
        if (roundingMode != null) {
            return Monetary.getRounding((RoundingQuery)((RoundingQueryBuilder)RoundingQueryBuilder.of().set((Object)roundingMode)).setScale(scale).build());
        }
        return Monetary.getDefaultRounding();
    }
}

