/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.io.InputStream;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.javamoney.moneta.convert.ECBRateReader;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.convert.LocalDate;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;
import org.xml.sax.helpers.DefaultHandler;

abstract class ECBAbstractRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    static final String BASE_CURRENCY_CODE = "EUR";
    public static final CurrencyUnit BASE_CURRENCY = Monetary.getCurrency((String)"EUR", (String[])new String[0]);
    protected final Map<LocalDate, Map<String, ExchangeRate>> rates = new ConcurrentHashMap<LocalDate, Map<String, ExchangeRate>>();
    private final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    protected volatile String loadState;
    protected volatile CountDownLatch loadLock = new CountDownLatch(1);

    public ECBAbstractRateProvider(ProviderContext context) {
        super(context);
        this.saxParserFactory.setNamespaceAware(false);
        this.saxParserFactory.setValidating(false);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, this.getDataId());
        loader.loadDataAsync(this.getDataId());
    }

    public abstract String getDataId();

    @Override
    public void newDataLoaded(String data, InputStream is) {
        try {
            int oldSize = this.rates.size();
            SAXParser parser = this.saxParserFactory.newSAXParser();
            parser.parse(is, (DefaultHandler)new ECBRateReader(this.rates, this.getContext()));
            int newSize = this.rates.size();
            this.loadState = "Loaded " + this.getDataId() + " exchange rates for days:" + (newSize - oldSize);
            this.LOGGER.info(this.loadState);
            this.loadLock.countDown();
        }
        catch (Exception e) {
            this.loadState = "Last Error during data load: " + e.getMessage();
            throw new IllegalArgumentException("Failed to load ECB data provided.", e);
        }
    }

    protected LocalDate[] getTargetDates(ConversionQuery query) {
        LocalDate date;
        if (this.rates.isEmpty()) {
            return new LocalDate[0];
        }
        Calendar cal = (Calendar)query.get(GregorianCalendar.class);
        if (cal == null) {
            cal = (Calendar)query.get(Calendar.class);
        }
        if (cal == null) {
            ArrayList<LocalDate> dates = new ArrayList<LocalDate>(this.rates.keySet());
            Collections.sort(dates);
            date = (LocalDate)dates.get(dates.size() - 1);
        } else {
            date = LocalDate.from(cal);
        }
        return new LocalDate[]{date, date.minusDays(1), date.minusDays(2), date.minusDays(3)};
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery query) {
        Objects.requireNonNull(query);
        try {
            if (this.loadLock.await(30L, TimeUnit.SECONDS)) {
                if (this.rates.isEmpty()) {
                    return null;
                }
                if (!this.isAvailable(query)) {
                    return null;
                }
                LocalDate selectedDate = null;
                Map<String, ExchangeRate> targets = null;
                for (LocalDate date : this.getTargetDates(query)) {
                    targets = this.rates.get(date);
                    if (targets == null) continue;
                    selectedDate = date;
                    break;
                }
                if (targets == null) {
                    return null;
                }
                ExchangeRateBuilder builder = this.getBuilder(query, selectedDate);
                ExchangeRate sourceRate = targets.get(query.getBaseCurrency().getCurrencyCode());
                ExchangeRate target = targets.get(query.getCurrency().getCurrencyCode());
                return this.createExchangeRate(query, builder, sourceRate, target);
            }
            this.loadLock.countDown();
            throw new MonetaryException("Failed to load currency conversion data: " + this.loadState);
        }
        catch (InterruptedException e) {
            throw new MonetaryException("Failed to load currency conversion data: Load task has been interrupted.", (Throwable)e);
        }
    }

    private ExchangeRate createExchangeRate(ConversionQuery query, ExchangeRateBuilder builder, ExchangeRate sourceRate, ExchangeRate target) {
        if (this.areBothBaseCurrencies(query)) {
            builder.setFactor(DefaultNumberValue.ONE);
            return builder.build();
        }
        if (BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode())) {
            if (sourceRate == null) {
                return null;
            }
            return this.reverse(sourceRate);
        }
        if (BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode())) {
            return target;
        }
        ExchangeRate rate1 = this.getExchangeRate(query.toBuilder().setTermCurrency(Monetary.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).build());
        ExchangeRate rate2 = this.getExchangeRate(query.toBuilder().setBaseCurrency(Monetary.getCurrency((String)BASE_CURRENCY_CODE, (String[])new String[0])).setTermCurrency(query.getCurrency()).build());
        if (rate1 != null && rate2 != null) {
            builder.setFactor(ECBAbstractRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
            builder.setRateChain(rate1, rate2);
            return builder.build();
        }
        throw new CurrencyConversionException(query.getBaseCurrency(), query.getCurrency(), sourceRate.getContext());
    }

    private boolean areBothBaseCurrencies(ConversionQuery query) {
        return BASE_CURRENCY_CODE.equals(query.getBaseCurrency().getCurrencyCode()) && BASE_CURRENCY_CODE.equals(query.getCurrency().getCurrencyCode());
    }

    private ExchangeRateBuilder getBuilder(ConversionQuery query, LocalDate localDate) {
        ExchangeRateBuilder builder = new ExchangeRateBuilder(((ConversionContextBuilder)((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.getContext(), (RateType)RateType.HISTORIC).set((Object)localDate)).set("LocalDate", (Object)localDate.toString())).build());
        builder.setBase(query.getBaseCurrency());
        builder.setTerm(query.getCurrency());
        return builder;
    }

    private ExchangeRate reverse(ExchangeRate rate) {
        if (rate == null) {
            throw new IllegalArgumentException("Rate null is not reversible.");
        }
        return new ExchangeRateBuilder(rate).setRate(rate).setBase(rate.getCurrency()).setTerm(rate.getBaseCurrency()).setFactor(ECBAbstractRateProvider.divide(DefaultNumberValue.ONE, rate.getFactor(), MathContext.DECIMAL64)).build();
    }
}

