/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import org.javamoney.moneta.convert.ECBHistoricRateProvider;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.convert.LocalDate;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ECBRateReader
extends DefaultHandler {
    private LocalDate localDate;
    private final Map<LocalDate, Map<String, ExchangeRate>> historicRates;
    private final ProviderContext context;

    public ECBRateReader(Map<LocalDate, Map<String, ExchangeRate>> historicRates, ProviderContext context) {
        this.historicRates = historicRates;
        this.context = context;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("Cube".equals(qName)) {
            if (attributes.getValue("time") != null) {
                this.localDate = this.parseLocalDate(attributes.getValue("time"));
            }
            if (attributes.getValue("currency") != null) {
                CurrencyUnit tgtCurrency = Monetary.getCurrency((String)attributes.getValue("currency"), (String[])new String[0]);
                this.addRate(tgtCurrency, this.localDate, BigDecimal.valueOf(Double.parseDouble(attributes.getValue("rate"))));
            }
        }
        super.startElement(uri, localName, qName, attributes);
    }

    private LocalDate parseLocalDate(String date) {
        String[] parts = date.split("-");
        return new LocalDate(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addRate(CurrencyUnit term, LocalDate localDate, Number rate) {
        ExchangeRateBuilder builder;
        RateType rateType = RateType.HISTORIC;
        if (localDate != null) {
            if (localDate.equals(LocalDate.now())) {
                rateType = RateType.DEFERRED;
            }
            builder = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.context, (RateType)rateType).set((Object)localDate)).build());
        } else {
            builder = new ExchangeRateBuilder(ConversionContextBuilder.create((ProviderContext)this.context, (RateType)rateType).build());
        }
        builder.setBase(ECBHistoricRateProvider.BASE_CURRENCY);
        builder.setTerm(term);
        builder.setFactor(DefaultNumberValue.of(rate));
        ExchangeRate exchangeRate = builder.build();
        Map<String, ExchangeRate> rateMap = this.historicRates.get(localDate);
        if (rateMap == null) {
            Map<LocalDate, Map<String, ExchangeRate>> map = this.historicRates;
            synchronized (map) {
                rateMap = this.historicRates.get(localDate);
                if (rateMap == null) {
                    rateMap = new ConcurrentHashMap<String, ExchangeRate>();
                    this.historicRates.put(localDate, rateMap);
                }
            }
        }
        rateMap.put(term.getCurrencyCode(), exchangeRate);
    }
}

