/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Currency;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.money.CurrencyContextBuilder;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryException;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import javax.money.spi.Bootstrap;
import org.javamoney.moneta.CurrencyUnitBuilder;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.convert.LocalDate;
import org.javamoney.moneta.spi.AbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;
import org.javamoney.moneta.spi.LoaderService;

public class IMFRateProvider
extends AbstractRateProvider
implements LoaderService.LoaderListener {
    private static final String DATA_ID = IMFRateProvider.class.getSimpleName();
    private static final ProviderContext CONTEXT = ((ProviderContextBuilder)((ProviderContextBuilder)ProviderContextBuilder.of((String)"IMF", (RateType)RateType.DEFERRED, (RateType[])new RateType[0]).set("providerDescription", (Object)"International Monetary Fund")).set("days", 1)).build();
    private static final CurrencyUnit SDR = CurrencyUnitBuilder.of("SDR", CurrencyContextBuilder.of((String)IMFRateProvider.class.getSimpleName()).build()).setDefaultFractionDigits(3).build(true);
    private Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    private Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
    protected volatile String loadState;
    protected volatile CountDownLatch loadLock = new CountDownLatch(1);
    private static final Map<String, CurrencyUnit> currenciesByName = new HashMap<String, CurrencyUnit>();

    public IMFRateProvider() {
        super(CONTEXT);
        LoaderService loader = (LoaderService)Bootstrap.getService(LoaderService.class);
        loader.addLoaderListener(this, DATA_ID);
        try {
            loader.loadData(DATA_ID);
        }
        catch (IOException e) {
            this.LOGGER.log(Level.WARNING, "Error loading initial data from IMF provider...", e);
        }
    }

    @Override
    public void newDataLoaded(String data, InputStream is) {
        try {
            int oldSize = this.sdrToCurrency.size();
            this.loadRatesTSV(is);
            int newSize = this.sdrToCurrency.size();
            this.loadState = "Loaded " + DATA_ID + " exchange rates for days:" + (newSize - oldSize);
            this.LOGGER.info(this.loadState);
            this.loadLock.countDown();
        }
        catch (Exception e) {
            this.loadState = "Last Error during data load: " + e.getMessage();
            throw new IllegalArgumentException("Failed to load IMF data provided.", e);
        }
    }

    private void loadRatesTSV(InputStream inputStream) throws IOException, ParseException {
        HashMap<CurrencyUnit, List<ExchangeRate>> newCurrencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        HashMap<CurrencyUnit, List<ExchangeRate>> newSdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        DecimalFormat f = new DecimalFormat("#0.0000000000");
        ((NumberFormat)f).setGroupingUsed(false);
        BufferedReader pr = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String line = pr.readLine();
        if (line.contains("Request Rejected")) {
            throw new IOException("Request has been rejected by IMF server.");
        }
        boolean currencyToSdr = true;
        List<LocalDate> timestamps = null;
        while (line != null) {
            if (line.trim().isEmpty()) {
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("SDRs per Currency unit")) {
                currencyToSdr = false;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency units per SDR")) {
                currencyToSdr = true;
                line = pr.readLine();
                continue;
            }
            if (line.startsWith("Currency")) {
                timestamps = this.readTimestamps(line);
                line = pr.readLine();
                continue;
            }
            String[] parts = line.split("\\t");
            CurrencyUnit currencyUnit = currenciesByName.get(parts[0].toLowerCase(Locale.ENGLISH));
            if (currencyUnit == null) {
                this.LOGGER.finest("Uninterpretable data from IMF data feed: " + parts[0]);
                line = pr.readLine();
                continue;
            }
            Double[] values = this.parseValues(parts);
            for (int i = 0; i < values.length; ++i) {
                List<Object> rates;
                ExchangeRate rate;
                LocalDate fromTS;
                if (values[i] == null) continue;
                LocalDate localDate = fromTS = timestamps != null ? timestamps.get(i) : null;
                if (fromTS == null) continue;
                RateType rateType = RateType.HISTORIC;
                if (fromTS.equals(LocalDate.now())) {
                    rateType = RateType.DEFERRED;
                }
                if (currencyToSdr) {
                    rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).set((Object)fromTS)).build()).setBase(currencyUnit).setTerm(SDR).setFactor(new DefaultNumberValue(1.0 / values[i])).build();
                    rates = (ArrayList<ExchangeRate>)newCurrencyToSdr.get(currencyUnit);
                    if (rates == null) {
                        rates = new ArrayList<ExchangeRate>(5);
                        newCurrencyToSdr.put(currencyUnit, rates);
                    }
                    rates.add(rate);
                    continue;
                }
                rate = new ExchangeRateBuilder(((ConversionContextBuilder)((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)CONTEXT, (RateType)rateType).set((Object)fromTS)).set("LocalTime", (Object)fromTS.toString())).build()).setBase(SDR).setTerm(currencyUnit).setFactor(DefaultNumberValue.of(1.0 / values[i])).build();
                rates = (List)newSdrToCurrency.get(currencyUnit);
                if (rates == null) {
                    rates = new ArrayList(5);
                    newSdrToCurrency.put(currencyUnit, rates);
                }
                rates.add(rate);
            }
            line = pr.readLine();
        }
        for (List list : newSdrToCurrency.values()) {
            Collections.sort((List)List.class.cast(list));
        }
        for (List list : newCurrencyToSdr.values()) {
            Collections.sort((List)List.class.cast(list));
        }
        this.sdrToCurrency = newSdrToCurrency;
        this.currencyToSdr = newCurrencyToSdr;
        for (Map.Entry entry : this.sdrToCurrency.entrySet()) {
            this.LOGGER.finest("SDR -> " + ((CurrencyUnit)entry.getKey()).getCurrencyCode() + ": " + entry.getValue());
        }
        for (Map.Entry entry : this.currencyToSdr.entrySet()) {
            this.LOGGER.finest(((CurrencyUnit)entry.getKey()).getCurrencyCode() + " -> SDR: " + entry.getValue());
        }
    }

    private Double[] parseValues(String[] parts) throws ParseException {
        ArrayList<Double> result = new ArrayList<Double>();
        int index = 0;
        for (String part : parts) {
            if (index == 0) {
                ++index;
                continue;
            }
            if (part.isEmpty() || "NA".equals(part)) {
                ++index;
                result.add(null);
                continue;
            }
            ++index;
            result.add(Double.valueOf(part.trim().replace(",", "")));
        }
        return result.toArray(new Double[parts.length - 1]);
    }

    private List<LocalDate> readTimestamps(String line) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("MMMM dd, yyyy", Locale.ENGLISH);
        String[] parts = line.split("\\\t");
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(parts.length);
        for (int i = 1; i < parts.length; ++i) {
            Calendar date = GregorianCalendar.getInstance();
            date.setTime(sdf.parse(parts[i]));
            dates.add(LocalDate.from(date));
        }
        return dates;
    }

    @Override
    public ExchangeRate getExchangeRate(ConversionQuery conversionQuery) {
        try {
            if (this.loadLock.await(30L, TimeUnit.SECONDS)) {
                ExchangeRate rate2;
                ExchangeRate rate1;
                if (this.currencyToSdr.isEmpty()) {
                    return null;
                }
                if (!this.isAvailable(conversionQuery)) {
                    return null;
                }
                CurrencyUnit base = conversionQuery.getBaseCurrency();
                CurrencyUnit term = conversionQuery.getCurrency();
                Calendar timestamp = (Calendar)conversionQuery.get(Calendar.class);
                if (timestamp == null) {
                    timestamp = (Calendar)conversionQuery.get(GregorianCalendar.class);
                }
                if (timestamp == null) {
                    LocalDate localDate = LocalDate.yesterday();
                    rate1 = this.lookupRate(this.currencyToSdr.get(base), localDate);
                    rate2 = this.lookupRate(this.sdrToCurrency.get(term), localDate);
                    if (rate1 == null || rate2 == null) {
                        localDate = LocalDate.beforeDays(2);
                    }
                    rate1 = this.lookupRate(this.currencyToSdr.get(base), localDate);
                    rate2 = this.lookupRate(this.sdrToCurrency.get(term), localDate);
                    if (rate1 == null || rate2 == null) {
                        localDate = LocalDate.beforeDays(3);
                        rate1 = this.lookupRate(this.currencyToSdr.get(base), localDate);
                        rate2 = this.lookupRate(this.sdrToCurrency.get(term), localDate);
                    }
                } else {
                    LocalDate localDate = LocalDate.from(timestamp);
                    rate1 = this.lookupRate(this.currencyToSdr.get(base), localDate);
                    rate2 = this.lookupRate(this.sdrToCurrency.get(term), localDate);
                }
                if (rate1 == null || rate2 == null) {
                    return null;
                }
                if (base.equals(SDR)) {
                    return rate2;
                }
                if (term.equals(SDR)) {
                    return rate1;
                }
                ExchangeRateBuilder builder = new ExchangeRateBuilder(ConversionContext.of((String)CONTEXT.getProviderName(), (RateType)RateType.HISTORIC));
                builder.setBase(base);
                builder.setTerm(term);
                builder.setFactor(IMFRateProvider.multiply(rate1.getFactor(), rate2.getFactor()));
                builder.setRateChain(rate1, rate2);
                return builder.build();
            }
            this.loadLock.countDown();
            throw new MonetaryException("Failed to load currency conversion data: " + this.loadState);
        }
        catch (InterruptedException e) {
            throw new MonetaryException("Failed to load currency conversion data: Load task has been interrupted.", (Throwable)e);
        }
    }

    private ExchangeRate lookupRate(List<ExchangeRate> list, LocalDate localDate) {
        if (list == null) {
            return null;
        }
        for (ExchangeRate rate : list) {
            if (localDate == null) {
                localDate = LocalDate.now();
            }
            if (rate == null) continue;
            return rate;
        }
        return null;
    }

    static {
        for (Currency currency : Currency.getAvailableCurrencies()) {
            currenciesByName.put(currency.getDisplayName(Locale.ENGLISH).toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)currency.getCurrencyCode(), (String[])new String[0]));
        }
        currenciesByName.put("U.K. pound".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"GBP", (String[])new String[0]));
        currenciesByName.put("U.S. dollar".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"USD", (String[])new String[0]));
        currenciesByName.put("Bahrain dinar".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"BHD", (String[])new String[0]));
        currenciesByName.put("Botswana pula".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"BWP", (String[])new String[0]));
        currenciesByName.put("Czech koruna".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"CZK", (String[])new String[0]));
        currenciesByName.put("Icelandic krona".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"ISK", (String[])new String[0]));
        currenciesByName.put("Korean won".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"KRW", (String[])new String[0]));
        currenciesByName.put("Omani rial".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"OMR", (String[])new String[0]));
        currenciesByName.put("Peruvian sol".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"PEN", (String[])new String[0]));
        currenciesByName.put("Qatari riyal".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"QAR", (String[])new String[0]));
        currenciesByName.put("Saudi Arabian riyal".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"SAR", (String[])new String[0]));
        currenciesByName.put("Sri Lankan rupee".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"LKR", (String[])new String[0]));
        currenciesByName.put("Trinidadian dollar".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"TTD", (String[])new String[0]));
        currenciesByName.put("U.A.E. dirham".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"AED", (String[])new String[0]));
        currenciesByName.put("Uruguayan peso".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"UYU", (String[])new String[0]));
        currenciesByName.put("Bolivar Fuerte".toLowerCase(Locale.ENGLISH), Monetary.getCurrency((String)"VEF", (String[])new String[0]));
    }
}

