/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryAmountFormat;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.function.MonetaryAmountProducer;

class MonetaryAmountDecimalFormat
implements MonetaryAmountFormat {
    static final String STYLE = "MonetaryAmountFormatSymbols";
    private static final AmountFormatContext CONTEXT = AmountFormatContextBuilder.of((String)"MonetaryAmountFormatSymbols").build();
    private final DecimalFormat decimalFormat;
    private final MonetaryAmountProducer producer;
    private final CurrencyUnit currencyUnit;

    public MonetaryAmountDecimalFormat(DecimalFormat decimalFormat, MonetaryAmountProducer producer, CurrencyUnit currencyUnit) {
        this.decimalFormat = decimalFormat;
        this.producer = producer;
        this.currencyUnit = currencyUnit;
    }

    DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    MonetaryAmountProducer getProducer() {
        return this.producer;
    }

    CurrencyUnit getCurrencyUnit() {
        return this.currencyUnit;
    }

    public String toLocalizedPattern() {
        return this.decimalFormat.toLocalizedPattern();
    }

    public String toPattern() {
        return this.decimalFormat.toPattern();
    }

    public AmountFormatContext getContext() {
        return CONTEXT;
    }

    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        Objects.requireNonNull(appendable).append(this.queryFrom(amount));
    }

    public MonetaryAmount parse(CharSequence text) throws MonetaryParseException {
        Objects.requireNonNull(text);
        try {
            Number number = this.decimalFormat.parse(text.toString());
            return this.producer.create(this.currencyUnit, number);
        }
        catch (Exception exception) {
            throw new MonetaryParseException(exception.getMessage(), text, 0);
        }
    }

    public String queryFrom(MonetaryAmount amount) {
        if (amount == null) {
            return "null";
        }
        return this.decimalFormat.format(amount.getNumber().numberValue(BigDecimal.class));
    }

    public int hashCode() {
        return Objects.hash(this.decimalFormat, this.currencyUnit, this.producer);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (MonetaryAmountDecimalFormat.class.isInstance(obj)) {
            MonetaryAmountDecimalFormat other = (MonetaryAmountDecimalFormat)MonetaryAmountDecimalFormat.class.cast(obj);
            return Objects.equals(other.decimalFormat, this.decimalFormat) && Objects.equals(other.producer, this.producer) && Objects.equals(other.currencyUnit, this.currencyUnit);
        }
        return false;
    }

    public String toString() {
        String sb = MonetaryAmountDecimalFormat.class.getName() + '{' + " decimalFormat: " + this.decimalFormat + ',' + " producer: " + this.producer + ',' + " currencyUnit: " + this.currencyUnit + '}';
        return sb;
    }

    public String format(MonetaryAmount amount) {
        StringBuilder sb = new StringBuilder();
        try {
            this.print(sb, amount);
        }
        catch (IOException e) {
            throw new IllegalStateException("Formatting error.", e);
        }
        return sb.toString();
    }
}

